/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import com.teammetallurgy.aquaculture.misc.AquacultureSounds;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class WormFarmBlock
extends ComposterBlock {
    public WormFarmBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.6f).m_60918_(SoundType.f_56736_));
    }

    public static void addCompostables() {
        WormFarmBlock.registerCompostable(AquaItems.ALGAE.m_5456_(), 0.3f);
        if (((Boolean)AquaConfig.BASIC_OPTIONS.compostableFish.get()).booleanValue()) {
            for (Item fish : AquacultureAPI.FISH_DATA.getFish()) {
                double weight = AquacultureAPI.FISH_DATA.getMinWeight(fish);
                ItemStack fishStack = new ItemStack((ItemLike)fish);
                if (fishStack.m_41783_() != null && fishStack.m_41783_().m_128441_("fishWeight")) {
                    weight = fishStack.m_41783_().m_128459_("fishWeight");
                }
                float chance = Mth.m_14036_((float)((float)FishData.getFilletAmountFromWeight(weight) * 0.25f), (float)0.05f, (float)0.65f);
                WormFarmBlock.registerCompostable(fish, chance);
            }
        }
    }

    public static void registerCompostable(Item item, float chance) {
        if (!f_51914_.containsKey((Object)item) && f_51914_.size() < 256) {
            f_51914_.put((Object)item, chance);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, BlockHitResult raytrace) {
        int level = (Integer)state.m_61143_((Property)f_51913_);
        ItemStack heldStack = player.m_21120_(hand);
        if (f_51914_.containsKey((Object)heldStack.m_41720_())) {
            if (level < 8 && !world.f_46443_) {
                boolean addItem = WormFarmBlock.addItem(state, (LevelAccessor)world, pos, heldStack);
                world.m_46796_(1500, pos, addItem ? 1 : 0);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (level > 0) {
            if (!world.f_46443_) {
                double x = (double)(world.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                double y = (double)(world.f_46441_.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double z = (double)(world.f_46441_.nextFloat() * 0.7f) + (double)0.15f;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, new ItemStack((ItemLike)AquaItems.WORM));
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51913_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)f_51913_) - 1)), 3);
            world.m_5594_(null, pos, AquacultureSounds.WORM_FARM_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7458_(BlockState state, @Nonnull ServerLevel world, @Nonnull BlockPos pos, Random random) {
    }

    private static boolean addItem(BlockState state, LevelAccessor world, BlockPos pos, @Nonnull ItemStack stack) {
        int level = (Integer)state.m_61143_((Property)f_51913_);
        float chance = f_51914_.getFloat((Object)stack.m_41720_());
        if ((level != 0 || chance <= 0.0f) && world.m_5822_().nextDouble() >= (double)chance) {
            return false;
        }
        int levelAdd = level + 1;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51913_, (Comparable)Integer.valueOf(levelAdd)), 3);
        if (levelAdd == 7) {
            world.m_6219_().m_5945_(pos, (Object)state.m_60734_(), 20);
        }
        return true;
    }

    @Nonnull
    public WorldlyContainer m_5840_(BlockState state, @Nonnull LevelAccessor world, @Nonnull BlockPos pos) {
        int level = (Integer)state.m_61143_((Property)f_51913_);
        if (level == 8) {
            return new FullInventory(state, world, pos, new ItemStack((ItemLike)AquaItems.WORM));
        }
        return level < 7 ? new PartialInventory(state, world, pos) : new EmptyInventory();
    }

    static class FullInventory
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor world;
        private final BlockPos pos;
        private boolean extracted;

        FullInventory(BlockState state, LevelAccessor world, BlockPos pos, @Nonnull ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int m_6893_() {
            return 1;
        }

        @Nonnull
        public int[] m_7071_(@Nonnull Direction direction) {
            int[] nArray;
            if (direction == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return !this.extracted && direction == Direction.DOWN && stack.m_41720_() == AquaItems.WORM;
        }

        public void m_6596_() {
            this.world.m_7731_(this.pos, (BlockState)this.state.m_61124_((Property)ComposterBlock.f_51913_, (Comparable)Integer.valueOf(0)), 3);
            this.extracted = true;
        }
    }

    static class PartialInventory
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor world;
        private final BlockPos pos;
        private boolean inserted;

        PartialInventory(BlockState state, LevelAccessor world, BlockPos pos) {
            super(1);
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int m_6893_() {
            return 1;
        }

        @Nonnull
        public int[] m_7071_(@Nonnull Direction direction) {
            int[] nArray;
            if (direction == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return !this.inserted && direction == Direction.UP && ComposterBlock.f_51914_.containsKey((Object)stack.m_41720_());
        }

        public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return false;
        }

        public void m_6596_() {
            ItemStack stack = this.m_8020_(0);
            if (!stack.m_41619_()) {
                this.inserted = true;
                WormFarmBlock.addItem(this.state, this.world, this.pos, stack);
                this.m_8016_(0);
            }
        }
    }

    static class EmptyInventory
    extends SimpleContainer
    implements WorldlyContainer {
        EmptyInventory() {
            super(0);
        }

        @Nonnull
        public int[] m_7071_(@Nonnull Direction direction) {
            return new int[0];
        }

        public boolean m_7155_(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return false;
        }
    }
}

