/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block.tileentity;

import com.teammetallurgy.aquaculture.block.tileentity.IItemHandlerTEBase;
import com.teammetallurgy.aquaculture.init.AquaBlocks;
import com.teammetallurgy.aquaculture.inventory.container.TackleBoxContainer;
import com.teammetallurgy.aquaculture.misc.AquacultureSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TackleBoxTileEntity
extends IItemHandlerTEBase
implements MenuProvider {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            TackleBoxTileEntity.playSound(level, pos, state, AquacultureSounds.TACKLE_BOX_OPEN);
        }

        protected void m_142289_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            TackleBoxTileEntity.playSound(level, pos, state, AquacultureSounds.TACKLE_BOX_CLOSE);
        }

        protected void m_142148_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, int i, int i1) {
            TackleBoxTileEntity.this.signalOpenCount(level, pos, state, i, i1);
        }

        protected boolean m_142718_(Player player) {
            return player.f_36096_ instanceof TackleBoxContainer;
        }
    };
    private final ChestLidController lidController = new ChestLidController();

    public TackleBoxTileEntity(BlockPos pos, BlockState state) {
        super(AquaBlocks.AquaTileEntities.TACKLE_BOX, pos, state);
    }

    @Override
    @Nonnull
    protected IItemHandler createItemHandler() {
        return new ItemStackHandler(17);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new TackleBoxContainer(windowID, this.f_58858_, playerInventory);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, TackleBoxTileEntity tackleBox) {
        tackleBox.lidController.m_155374_();
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int i, int i1) {
        Block block = state.m_60734_();
        level.m_7696_(pos, block, 1, i1);
    }

    static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        if (level != null) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean m_7531_(int p_59114_, int p_59115_) {
        if (p_59114_ == 1) {
            this.lidController.m_155377_(p_59115_ > 0);
            return true;
        }
        return super.m_7531_(p_59114_, p_59115_);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.lidController.m_155375_(partialTicks);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }
}

