/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class FishMountRenderer
extends EntityRenderer<FishMountEntity> {
    public static final ModelResourceLocation OAK = new ModelResourceLocation(new ResourceLocation("aquaculture", "oak_fish_mount"), "");
    public static final ModelResourceLocation SPRUCE = new ModelResourceLocation(new ResourceLocation("aquaculture", "spruce_fish_mount"), "");
    public static final ModelResourceLocation BIRCH = new ModelResourceLocation(new ResourceLocation("aquaculture", "birch_fish_mount"), "");
    public static final ModelResourceLocation JUNGLE = new ModelResourceLocation(new ResourceLocation("aquaculture", "jungle_fish_mount"), "");
    public static final ModelResourceLocation ACACIA = new ModelResourceLocation(new ResourceLocation("aquaculture", "acacia_fish_mount"), "");
    public static final ModelResourceLocation DARK_OAK = new ModelResourceLocation(new ResourceLocation("aquaculture", "dark_oak_fish_mount"), "");
    private final Minecraft mc = Minecraft.m_91087_();

    public FishMountRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@Nonnull FishMountEntity fishMount, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        super.m_7392_((Entity)fishMount, entityYaw, partialTicks, matrixStack, buffer, i);
        matrixStack.m_85836_();
        Direction direction = fishMount.m_6350_();
        Vec3 pos = this.getRenderOffset(fishMount, partialTicks);
        matrixStack.m_85837_(-pos.m_7096_(), -pos.m_7098_(), -pos.m_7094_());
        double multiplier = 0.46875;
        matrixStack.m_85837_((double)direction.m_122429_() * multiplier, (double)direction.m_122430_() * multiplier, (double)direction.m_122431_() * multiplier);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(fishMount.m_146909_()));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - fishMount.m_146908_()));
        BlockRenderDispatcher rendererDispatcher = this.mc.m_91289_();
        ModelManager manager = rendererDispatcher.m_110907_().m_110881_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        if (fishMount.m_6095_().getRegistryName() != null) {
            ModelResourceLocation location = new ModelResourceLocation(fishMount.m_6095_().getRegistryName(), "");
            rendererDispatcher.m_110937_().m_111067_(matrixStack.m_85850_(), buffer.m_6299_(Sheets.m_110789_()), null, manager.m_119422_(location), 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        this.renderFish(fishMount, matrixStack, buffer, i);
        matrixStack.m_85849_();
    }

    private void renderFish(FishMountEntity fishMount, PoseStack matrixStack, MultiBufferSource buffer, int i) {
        Entity entity = fishMount.entity;
        Entity entity2 = entity;
        if (entity2 instanceof Mob) {
            Mob fish = (Mob)entity2;
            double x = 0.0;
            double y = 0.0;
            double depth = 0.42;
            if (fish instanceof Pufferfish) {
                depth += 0.09;
            } else if (fish instanceof AquaFishEntity && AquaFishEntity.TYPES.get(fish.m_6095_()).equals((Object)FishType.LONGNOSE)) {
                x = -0.1f;
                y = -0.18;
            }
            fish.m_21557_(true);
            matrixStack.m_85837_(x, y, depth);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            this.mc.m_91290_().m_114384_((Entity)fish, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull FishMountEntity fishMount) {
        return InventoryMenu.f_39692_;
    }

    @Nonnull
    public Vec3 getRenderOffset(FishMountEntity fishMount, float partialTicks) {
        return new Vec3((double)((float)fishMount.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)fishMount.m_6350_().m_122431_() * 0.3f));
    }

    protected boolean shouldShowName(@Nonnull FishMountEntity fishMount) {
        if (Minecraft.m_91404_() && fishMount.entity != null && this.mc.f_91077_ != null && fishMount.m_20238_(this.mc.f_91077_.m_82450_()) < 0.24) {
            double d0 = this.f_114476_.m_114471_((Entity)fishMount);
            float sneaking = fishMount.m_20163_() ? 32.0f : 64.0f;
            return d0 < (double)(sneaking * sneaking);
        }
        return false;
    }

    protected void renderNameTag(@Nonnull FishMountEntity fishMount, @Nonnull Component name, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        super.m_7649_((Entity)fishMount, fishMount.entity.m_5446_(), matrixStack, buffer, i);
        ItemStack stack = fishMount.getDisplayedItem();
        if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("fishWeight")) {
            double weight = stack.m_41783_().m_128459_("fishWeight");
            String lb = weight == 1.0 ? " lb" : " lbs";
            DecimalFormat df = new DecimalFormat("#,###.##");
            BigDecimal bd = new BigDecimal(weight);
            bd = bd.round(new MathContext(3));
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, -0.25, 0.0);
            if (bd.doubleValue() > 999.0) {
                super.m_7649_((Entity)fishMount, (Component)new TranslatableComponent("aquaculture.fishWeight.weight", new Object[]{df.format((int)bd.doubleValue()) + lb}), matrixStack, buffer, i - 100);
            } else {
                super.m_7649_((Entity)fishMount, (Component)new TranslatableComponent("aquaculture.fishWeight.weight", new Object[]{bd + lb}), matrixStack, buffer, i);
            }
            matrixStack.m_85849_();
        }
    }
}

