/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.block.FarmlandMoistBlock;
import com.teammetallurgy.aquaculture.block.NeptunesBountyBlock;
import com.teammetallurgy.aquaculture.block.TackleBoxBlock;
import com.teammetallurgy.aquaculture.block.WormFarmBlock;
import com.teammetallurgy.aquaculture.block.tileentity.NeptunesBountyTileEntity;
import com.teammetallurgy.aquaculture.block.tileentity.TackleBoxTileEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.BlockItemWithoutLevelRenderer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="aquaculture")
public class AquaBlocks {
    public static List<Block> BLOCKS = Lists.newArrayList();
    public static final Block FARMLAND = AquaBlocks.register((Block)new FarmlandMoistBlock(), "farmland", null);
    public static final Block NEPTUNIUM_BLOCK = AquaBlocks.register(new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76421_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)), "neptunium_block");
    public static final Block NEPTUNES_BOUNTY = AquaBlocks.registerWithRenderer((Block)new NeptunesBountyBlock(), "neptunes_bounty", new Item.Properties());
    public static final Block TACKLE_BOX = AquaBlocks.registerWithRenderer((Block)new TackleBoxBlock(), "tackle_box", new Item.Properties());
    public static final Block WORM_FARM = AquaBlocks.register((Block)new WormFarmBlock(), "worm_farm");

    public static Block register(@Nonnull Block block, @Nonnull String name) {
        return AquaBlocks.register(block, name, new Item.Properties());
    }

    public static Block register(@Nonnull Block block, @Nonnull String name, @Nullable Item.Properties properties) {
        AquaBlocks.registerBaseBlock(block, name);
        AquaItems.register((Item)new BlockItem(block, properties == null ? new Item.Properties() : properties.m_41491_(Aquaculture.GROUP)), name);
        return block;
    }

    public static Block registerWithRenderer(@Nonnull Block block, @Nonnull String name, @Nullable Item.Properties properties) {
        AquaBlocks.registerBaseBlock(block, name);
        AquaItems.register((Item)new BlockItemWithoutLevelRenderer(block, properties == null ? new Item.Properties() : properties.m_41491_(Aquaculture.GROUP)), name);
        return block;
    }

    public static Block registerBaseBlock(@Nonnull Block block, @Nonnull String name) {
        block.setRegistryName(new ResourceLocation("aquaculture", name));
        BLOCKS.add(block);
        return block;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
    @ObjectHolder(value="aquaculture")
    public static class AquaTileEntities {
        public static List<BlockEntityType<?>> TILE_ENTITIES = Lists.newArrayList();
        public static final BlockEntityType<NeptunesBountyTileEntity> NEPTUNES_BOUNTY = AquaTileEntities.register("neptunes_bounty", BlockEntityType.Builder.m_155273_(NeptunesBountyTileEntity::new, (Block[])new Block[]{NEPTUNES_BOUNTY}));
        public static final BlockEntityType<TackleBoxTileEntity> TACKLE_BOX = AquaTileEntities.register("tackle_box", BlockEntityType.Builder.m_155273_(TackleBoxTileEntity::new, (Block[])new Block[]{TACKLE_BOX}));

        public static <T extends BlockEntity> BlockEntityType<T> register(@Nonnull String name, @Nonnull BlockEntityType.Builder<T> builder) {
            BlockEntityType tileEntityType = builder.m_58966_(null);
            tileEntityType.setRegistryName(new ResourceLocation("aquaculture", name));
            TILE_ENTITIES.add(tileEntityType);
            return tileEntityType;
        }

        @SubscribeEvent
        public static void registerTileEntity(RegistryEvent.Register<BlockEntityType<?>> event) {
            for (BlockEntityType<?> tileEntity : TILE_ENTITIES) {
                event.getRegistry().register(tileEntity);
            }
        }
    }
}

