/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.entity.SpectralWaterArrowEntity;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import com.teammetallurgy.aquaculture.entity.WaterArrowEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import com.teammetallurgy.aquaculture.misc.BiomeDictionaryHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="aquaculture")
public class AquaEntities {
    private static final List<EntityType<?>> ENTITIES = Lists.newArrayList();
    private static final List<EntityType<?>> MOBS = Lists.newArrayList();
    public static final EntityType<AquaFishingBobberEntity> BOBBER = AquaEntities.register("bobber", EntityType.Builder.m_20710_((MobCategory)MobCategory.MISC).m_20716_().m_20698_().m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(5).setCustomClientFactory(AquaFishingBobberEntity::new));
    public static final EntityType<WaterArrowEntity> WATER_ARROW = AquaEntities.register("water_arrow", EntityType.Builder.m_20704_(WaterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(WaterArrowEntity::new));
    public static final EntityType<SpectralWaterArrowEntity> SPECTRAL_WATER_ARROW = AquaEntities.register("spectral_water_arrow", EntityType.Builder.m_20704_(SpectralWaterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(SpectralWaterArrowEntity::new));
    public static final EntityType<TurtleLandEntity> BOX_TURTLE = AquaEntities.registerMob("box_turtle", 1, 2, 10, BiomeDictionary.Type.SWAMP, null, 8356921, 6119722, EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));
    public static final EntityType<TurtleLandEntity> ARRAU_TURTLE = AquaEntities.registerMob("arrau_turtle", 1, 2, 8, BiomeDictionary.Type.JUNGLE, null, 7439738, 5202520, EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));
    public static final EntityType<TurtleLandEntity> STARSHELL_TURTLE = AquaEntities.registerMob("starshell_turtle", 1, 2, 5, BiomeDictionaryHelper.TWILIGHT, null, 14476005, 0x464645, EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<?> entity : ENTITIES) {
            event.getRegistry().register(entity);
        }
    }

    private static <T extends Mob> EntityType<T> registerMob(String name, int min, int max, int weight, BiomeDictionary.Type include, @Nullable BiomeDictionary.Type exclude, int eggPrimary, int eggSecondary, EntityType.Builder<T> builder) {
        return AquaEntities.registerMob(name, min, max, weight, eggPrimary, eggSecondary, Collections.singletonList(String.valueOf(include == null ? "" : include)), Collections.singletonList(String.valueOf(exclude == null ? "" : exclude)), builder);
    }

    private static <T extends Mob> EntityType<T> registerMob(String name, int min, int max, int weight, int eggPrimary, int eggSecondary, List<? extends String> include, List<? extends String> exclude, EntityType.Builder<T> builder) {
        EntityType<T> entityType = AquaEntities.register(name, builder);
        SpawnEggItem spawnEgg = new SpawnEggItem(entityType, eggPrimary, eggSecondary, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
        AquaItems.register((Item)spawnEgg, name + "_spawn_egg");
        new AquaConfig.Spawn(AquaConfig.BUILDER, name, min, max, weight, include, exclude);
        MOBS.add(entityType);
        return entityType;
    }

    public static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder) {
        ResourceLocation location = new ResourceLocation("aquaculture", name);
        EntityType entityType = builder.m_20712_(location.toString());
        entityType.setRegistryName(location);
        ENTITIES.add(entityType);
        return entityType;
    }

    public static void setSpawnPlacement() {
        SpawnPlacements.m_21754_(BOX_TURTLE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(ARRAU_TURTLE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_(STARSHELL_TURTLE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(BOX_TURTLE, TurtleLandEntity.createAttributes().m_22265_());
        event.put(ARRAU_TURTLE, TurtleLandEntity.createAttributes().m_22265_());
        event.put(STARSHELL_TURTLE, TurtleLandEntity.createAttributes().m_22265_());
    }

    public static void addEntitySpawns(BiomeLoadingEvent event) {
        for (EntityType<?> entityType : MOBS) {
            String name = Objects.requireNonNull(entityType.getRegistryName()).m_135815_();
            String subCategory = AquaConfig.Helper.getSubConfig("spawn options", name);
            BiomeDictionaryHelper.addSpawn(entityType, (Integer)AquaConfig.Helper.get(subCategory, "min"), (Integer)AquaConfig.Helper.get(subCategory, "max"), (Integer)AquaConfig.Helper.get(subCategory, "weight"), (List)AquaConfig.Helper.get(subCategory, "include"), (List)AquaConfig.Helper.get(subCategory, "exclude"), event);
        }
    }
}

