/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishMountEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.init.AquaEntities;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.item.FishMountItem;
import com.teammetallurgy.aquaculture.misc.StackHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FishRegistry {
    public static List<EntityType<AquaFishEntity>> fishEntities = Lists.newArrayList();
    public static List<EntityType<FishMountEntity>> fishMounts = Lists.newArrayList();

    public static Item registerFishMount(@Nonnull String name) {
        EntityType.Builder fishMountBuilder = EntityType.Builder.m_20704_(FishMountEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(FishMountEntity::new);
        EntityType fishMount = AquaEntities.register(name, fishMountBuilder);
        FishMountItem fishMountItem = new FishMountItem(fishMount);
        AquaItems.register((Item)fishMountItem, name);
        fishMounts.add(fishMount);
        return fishMountItem;
    }

    public static Item register(@Nonnull Item fishItem, @Nonnull String name) {
        return FishRegistry.register(fishItem, name, FishType.MEDIUM);
    }

    public static Item register(@Nonnull Item fishItem, @Nonnull String name, FishType fishSize) {
        AquaItems.register(fishItem, name);
        EntityType fish = EntityType.Builder.m_20704_(AquaFishEntity::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(fishSize.getWidth(), fishSize.getHeight()).m_20712_("minecraft:cod");
        FishRegistry.registerFishEntity(name, (EntityType<AquaFishEntity>)fish);
        AquaFishEntity.TYPES.put((EntityType<AquaFishEntity>)fish, fishSize);
        return fishItem;
    }

    public static EntityType<AquaFishEntity> registerFishEntity(String name, EntityType<AquaFishEntity> entityType) {
        ResourceLocation location = new ResourceLocation("aquaculture", name);
        entityType.setRegistryName(location);
        fishEntities.add(entityType);
        return entityType;
    }

    @SubscribeEvent
    public static void registerFishies(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<AquaFishEntity> entityType : fishEntities) {
            event.getRegistry().register(entityType);
            SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AquaFishEntity::canSpawnHere);
        }
    }

    @SubscribeEvent
    public static void addFishEntity0Attributes(EntityAttributeCreationEvent event) {
        for (EntityType<AquaFishEntity> entityType : fishEntities) {
            event.put(entityType, AbstractFish.m_27495_().m_22265_());
        }
    }

    public static void addCatBreeding() {
        try {
            Ingredient catBreedingItems = Cat.f_28103_;
            Ingredient ocelotBreedingItems = Ocelot.f_28981_;
            ArrayList<ItemStack> aquaFish = new ArrayList<ItemStack>();
            fishEntities.forEach(f -> aquaFish.add(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(f.getRegistryName()))));
            aquaFish.removeIf(p -> p.m_41720_().equals(AquaItems.JELLYFISH));
            Cat.f_28103_ = StackHelper.mergeIngredient(catBreedingItems, StackHelper.ingredientFromStackList(aquaFish));
            Ocelot.f_28981_ = StackHelper.mergeIngredient(ocelotBreedingItems, StackHelper.ingredientFromStackList(aquaFish));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

