/*
 * Decompiled with CFR 0.152.
 */
package com.abneyonline.platter;

import com.abneyonline.platter.tile.AcaciaPlatterTile;
import com.abneyonline.platter.tile.BirchPlatterTile;
import com.abneyonline.platter.tile.CrimsonPlatterTile;
import com.abneyonline.platter.tile.DarkOakPlatterTile;
import com.abneyonline.platter.tile.GoldPlatterTile;
import com.abneyonline.platter.tile.IronPlatterTile;
import com.abneyonline.platter.tile.JunglePlatterTile;
import com.abneyonline.platter.tile.OakPlatterTile;
import com.abneyonline.platter.tile.PlatterTile;
import com.abneyonline.platter.tile.SprucePlatterTile;
import com.abneyonline.platter.tile.StonePlatterTile;
import com.abneyonline.platter.tile.WarpedPlatterTile;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlatterBlock
extends Block
implements EntityBlock {
    private static final VoxelShape RENDER_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);

    public PlatterBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(1.0f));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (!worldIn.m_5776_()) {
            ItemStack playerHand = player.m_21205_();
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                if (player.m_6047_()) {
                    for (int a = h.getSlots() - 1; a >= 0; --a) {
                        ItemStack found = h.getStackInSlot(a);
                        if (found.m_41619_()) continue;
                        ItemStack toRemove = h.extractItem(a, found.m_41613_(), false);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)toRemove);
                        tileEntity.m_6596_();
                        worldIn.m_7260_(pos, state, state, 2);
                        return;
                    }
                } else {
                    ItemStack toInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)playerHand.m_41777_(), (boolean)false);
                    if (!player.m_7500_()) {
                        playerHand.m_41774_(playerHand.m_41613_() - toInsert.m_41613_());
                    }
                    tileEntity.m_6596_();
                    worldIn.m_7260_(pos, state, state, 2);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_()) {
            ArrayList toDrop = new ArrayList();
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                for (int a = 0; a < h.getSlots(); ++a) {
                    if (h.getStackInSlot(a).m_41619_()) continue;
                    toDrop.add(h.getStackInSlot(a).m_41777_());
                }
            });
            for (int a = 0; a < toDrop.size(); ++a) {
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((ItemStack)toDrop.get(a)));
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return (level1, blockPos, blockState, t) -> {
            BlockEntity tile$temp = t;
            if (tile$temp instanceof PlatterTile) {
                PlatterTile tile = (PlatterTile)tile$temp;
                tile.tickServer();
            }
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        String toCheck = this.getRegistryName().m_135815_();
        if (toCheck.contains("oak") && !toCheck.contains("dark")) {
            return new OakPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("spruce")) {
            return new SprucePlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("birch")) {
            return new BirchPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("jungle")) {
            return new JunglePlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("acacia")) {
            return new AcaciaPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("dark")) {
            return new DarkOakPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("stone")) {
            return new StonePlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("iron")) {
            return new IronPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("gold")) {
            return new GoldPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("crimson")) {
            return new CrimsonPlatterTile(blockPos, blockState);
        }
        if (toCheck.contains("warped")) {
            return new WarpedPlatterTile(blockPos, blockState);
        }
        return new PlatterTile(blockPos, blockState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        boolean toReturn = false;
        LazyOptional handler = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (handler.isPresent()) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)handler.orElse(null)));
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return RENDER_SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return RENDER_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return RENDER_SHAPE;
    }
}

