/*
 * Decompiled with CFR 0.152.
 */
package com.abneyonline.platter.network;

import com.abneyonline.platter.network.MessageExhaustionSync;
import com.abneyonline.platter.network.MessageSaturationSync;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;

public class SyncHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("platter", "sync")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    public static void init() {
        CHANNEL.registerMessage(1, MessageExhaustionSync.class, MessageExhaustionSync::encode, MessageExhaustionSync::decode, MessageExhaustionSync::handle);
        CHANNEL.registerMessage(2, MessageSaturationSync.class, MessageSaturationSync::encode, MessageSaturationSync::decode, MessageSaturationSync::handle);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Float lastSaturationLevel = lastSaturationLevels.get(player.m_142081_());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.m_142081_());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.m_36324_().m_38722_()) {
            MessageSaturationSync msg = new MessageSaturationSync(player.m_36324_().m_38722_());
            CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            lastSaturationLevels.put(player.m_142081_(), Float.valueOf(player.m_36324_().m_38722_()));
        }
        float exhaustionLevel = player.m_36324_().m_150380_();
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            MessageExhaustionSync msg = new MessageExhaustionSync(exhaustionLevel);
            CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            lastExhaustionLevels.put(player.m_142081_(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayer)) {
            return;
        }
        lastSaturationLevels.remove(event.getPlayer().m_142081_());
        lastExhaustionLevels.remove(event.getPlayer().m_142081_());
    }
}

