/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.function.UnaryOperator;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import me.shedaniel.rei.PluginDetector;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.impl.common.category.CategoryIdentifierImpl;
import me.shedaniel.rei.impl.common.display.DisplaySerializerRegistryImpl;
import me.shedaniel.rei.impl.common.entry.DeferringEntryTypeProviderImpl;
import me.shedaniel.rei.impl.common.entry.EntryIngredientImpl;
import me.shedaniel.rei.impl.common.entry.EntryStackProviderImpl;
import me.shedaniel.rei.impl.common.entry.comparison.FluidComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.ItemComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.NbtHasherProviderImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeRegistryImpl;
import me.shedaniel.rei.impl.common.fluid.FluidSupportProviderImpl;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.registry.RecipeManagerContextImpl;
import me.shedaniel.rei.impl.common.transfer.MenuInfoRegistryImpl;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.Unit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RoughlyEnoughItemsCore {
    @ApiStatus.Internal
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");

    public static void attachCommonInternals() {
        CategoryIdentifierImpl.attach();
        Internals.attachInstance(DeferringEntryTypeProviderImpl.INSTANCE, "entryTypeDeferred");
        Internals.attachInstance(EntryStackProviderImpl.INSTANCE, Internals.EntryStackProvider.class);
        Internals.attachInstance(NbtHasherProviderImpl.INSTANCE, Internals.NbtHasherProvider.class);
        Internals.attachInstance(EntryIngredientImpl.INSTANCE, Internals.EntryIngredientProvider.class);
        Internals.attachInstanceSupplier(new PluginManagerImpl<REIPlugin>(REIPlugin.class, UnaryOperator.identity(), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d entry types, %d item comparators, %d fluid comparators and %d fluid support providers in %dms.", (Object)REIPlugin.class.getSimpleName(), (Object)EntryTypeRegistry.getInstance().values().size(), (Object)ItemComparatorRegistry.getInstance().comparatorSize(), (Object)FluidComparatorRegistry.getInstance().comparatorSize(), (Object)FluidSupportProvider.getInstance().size(), (Object)usedTime), new EntryTypeRegistryImpl(), new RecipeManagerContextImpl(RecipeManagerContextImpl.supplier()), new ItemComparatorRegistryImpl(), new FluidComparatorRegistryImpl(), new DisplaySerializerRegistryImpl(), new FluidSupportProviderImpl()), "commonPluginManager");
        Internals.attachInstanceSupplier(new PluginManagerImpl<REIServerPlugin>(REIServerPlugin.class, view -> view.then(PluginView.getInstance()), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d menu infos in %dms.", (Object)REIServerPlugin.class.getSimpleName(), (Object)MenuInfoRegistry.getInstance().infoSize(), (Object)usedTime), new MenuInfoRegistryImpl()), "serverPluginManager");
    }

    public static void _reloadPlugins(@Nullable ReloadStage stage) {
        if (stage == null) {
            for (ReloadStage reloadStage : ReloadStage.values()) {
                RoughlyEnoughItemsCore._reloadPlugins(reloadStage);
            }
            return;
        }
        try {
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.view().pre();
            }
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.startReload(stage);
            }
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.view().post();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onInitialize() {
        PluginDetector.detectCommonPlugins();
        PluginDetector.detectServerPlugins();
        RoughlyEnoughItemsNetwork.onInitialize();
        if (Platform.getEnvironment() == Env.SERVER) {
            MutableLong lastReload = new MutableLong(-1L);
            ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2) -> preparationBarrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> RoughlyEnoughItemsCore._reloadPlugins(null), executor2));
        }
    }

    static {
        RoughlyEnoughItemsCore.attachCommonInternals();
        if (Platform.getEnvironment() == Env.CLIENT) {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> RoughlyEnoughItemsCoreClient::attachClientInternals);
        }
    }
}

