/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRecipeUpdateEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.PluginDetector;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.favorites.DelegatingFavoriteEntryProviderImpl;
import me.shedaniel.rei.impl.client.favorites.FavoriteEntryTypeRegistryImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.client.registry.category.CategoryRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.registry.screen.ScreenRegistryImpl;
import me.shedaniel.rei.impl.client.search.SearchProviderImpl;
import me.shedaniel.rei.impl.client.subsets.SubsetsRegistryImpl;
import me.shedaniel.rei.impl.client.transfer.TransferHandlerRegistryImpl;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.util.IssuesDetector;
import me.shedaniel.rei.plugin.test.REITestPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class RoughlyEnoughItemsCoreClient {
    public static final Event<ClientRecipeUpdateEvent> PRE_UPDATE_RECIPES = EventFactory.createLoop((Object[])new ClientRecipeUpdateEvent[0]);
    @ApiStatus.Experimental
    public static boolean isLeftMousePressed = false;
    private static final ExecutorService RELOAD_PLUGINS = Executors.newSingleThreadScheduledExecutor(task -> {
        Thread thread = new Thread(task, "REI-ReloadPlugins");
        thread.setDaemon(true);
        return thread;
    });

    public static void attachClientInternals() {
        InternalWidgets.attach();
        EmptyEntryDefinition.EmptyRenderer emptyEntryRenderer = new EmptyEntryDefinition.EmptyRenderer();
        ClientInternals.attachInstance(() -> emptyEntryRenderer, "emptyEntryRenderer");
        ClientInternals.attachInstance(DelegatingFavoriteEntryProviderImpl::new, "delegateFavoriteEntry");
        ClientInternals.attachInstance(object -> {
            String type = object.m_128461_("type");
            ResourceLocation id = new ResourceLocation(type);
            FavoriteEntryType entryType = FavoriteEntryType.registry().get(id);
            if (entryType == null) {
                return DataResult.error((String)("Unknown favorite type: " + id + ", json: " + object));
            }
            return entryType.readResult((CompoundTag)object);
        }, "favoriteEntryFromJson");
        ClientInternals.attachInstance(QueuedTooltip::impl, "tooltipProvider");
        ClientInternals.attachInstance(QueuedTooltip.TooltipEntryImpl::new, "tooltipEntryProvider");
        ClientInternals.attachInstance(successful -> new ClickArea.Result((Boolean)successful){
            private List<CategoryIdentifier<?>> categories = Lists.newArrayList();
            final /* synthetic */ Boolean val$successful;
            {
                this.val$successful = bl;
            }

            @Override
            public ClickArea.Result category(CategoryIdentifier<?> category) {
                this.categories.add(category);
                return this;
            }

            @Override
            public boolean isSuccessful() {
                return this.val$successful;
            }

            @Override
            public Stream<CategoryIdentifier<?>> getCategories() {
                return this.categories.stream();
            }
        }, "clickAreaHandlerResult");
        ClientInternals.attachInstanceSupplier(new PluginManagerImpl<REIClientPlugin>(REIClientPlugin.class, view -> view.then(PluginView.getInstance()), usedTime -> RoughlyEnoughItemsCore.LOGGER.info("Reloaded Plugin Manager [%s] with %d entries, %d displays, %d display visibility predicates, %d categories (%s), %d exclusion zones and %d overlay deciders in %dms.", (Object)REIClientPlugin.class.getSimpleName(), (Object)EntryRegistry.getInstance().size(), (Object)DisplayRegistry.getInstance().displaySize(), (Object)DisplayRegistry.getInstance().getVisibilityPredicates().size(), (Object)CategoryRegistry.getInstance().size(), (Object)CategoryRegistry.getInstance().stream().map(CategoryRegistry.CategoryConfiguration::getCategory).map(DisplayCategory::getTitle).map(Component::getString).collect(Collectors.joining(", ")), (Object)ScreenRegistry.getInstance().exclusionZones().getZonesCount(), (Object)ScreenRegistry.getInstance().getDeciders().size(), (Object)usedTime), new ViewsImpl(), new SearchProviderImpl(), new ConfigManagerImpl(), new EntryRegistryImpl(), new CategoryRegistryImpl(), new DisplayRegistryImpl(), new ScreenRegistryImpl(), new FavoriteEntryTypeRegistryImpl(), new SubsetsRegistryImpl(), new TransferHandlerRegistryImpl(), new REIRuntimeImpl()), "clientPluginManager");
    }

    public void onInitializeClient() {
        IssuesDetector.detect();
        this.registerEvents();
        PluginDetector.detectClientPlugins();
        this.loadTestPlugins();
        Minecraft client = Minecraft.m_91087_();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (buf, context) -> {
            ItemStack stack = buf.m_130267_();
            String player = buf.m_130136_(Short.MAX_VALUE);
            if (client.f_91074_ != null) {
                client.f_91074_.m_5661_((Component)new TextComponent(I18n.m_118938_((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", EntryStacks.of(stack.m_41777_()).asFormattedText().getString()).replaceAll("\\{item_count}", "" + stack.m_41777_().m_41613_()).replaceAll("\\{player_name}", player)), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)RoughlyEnoughItemsNetwork.NOT_ENOUGH_ITEMS_PACKET, (buf, context) -> {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            Screen craftingScreen$temp = currentScreen;
            if (craftingScreen$temp instanceof CraftingScreen) {
                CraftingScreen craftingScreen = (CraftingScreen)craftingScreen$temp;
                RecipeBookComponent recipeBookGui = craftingScreen.m_5564_();
                GhostRecipe ghostSlots = recipeBookGui.f_100269_;
                ghostSlots.m_100140_();
                ArrayList input = Lists.newArrayList();
                int mapSize = buf.readInt();
                for (int i = 0; i < mapSize; ++i) {
                    ArrayList list = Lists.newArrayList();
                    int count = buf.readInt();
                    for (int j = 0; j < count; ++j) {
                        list.add(buf.m_130267_());
                    }
                    input.add(list);
                }
                ghostSlots.m_100143_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41905_}), 381203812, 12738291);
                CraftingMenu container = (CraftingMenu)craftingScreen.m_6262_();
                for (int i = 0; i < input.size(); ++i) {
                    List stacks = (List)input.get(i);
                    if (stacks.isEmpty()) continue;
                    Slot slot = container.m_38853_(i + container.m_6636_() + 1);
                    ghostSlots.m_100143_(Ingredient.m_43927_((ItemStack[])stacks.toArray(new ItemStack[0])), slot.f_40220_, slot.f_40221_);
                }
            }
        });
    }

    private void loadTestPlugins() {
        if (System.getProperty("rei.test", "false").equals("true")) {
            PluginView.getClientInstance().registerPlugin(new REITestPlugin());
        }
    }

    public static boolean shouldReturn(Screen screen) {
        if (REIRuntime.getInstance().getOverlay().isEmpty()) {
            return true;
        }
        if (screen == null) {
            return true;
        }
        if (screen != Minecraft.m_91087_().f_91080_) {
            return true;
        }
        return RoughlyEnoughItemsCoreClient._shouldReturn(screen);
    }

    private static ScreenOverlay getOverlay() {
        return REIRuntime.getInstance().getOverlay().orElseThrow(() -> new IllegalStateException("Overlay not initialized!"));
    }

    private static boolean _shouldReturn(Screen screen) {
        try {
            Class<?> screenClass = screen.getClass();
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders()) {
                InteractionResult result;
                if (!decider.isHandingScreen(screen.getClass()) || (result = decider.shouldScreenBeOverlaid(screenClass)) == InteractionResult.PASS) continue;
                return result == InteractionResult.FAIL || REIRuntime.getInstance().getPreviousScreen() == null;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return true;
    }

    private void registerEvents() {
        Minecraft client = Minecraft.m_91087_();
        ResourceLocation recipeButtonTex = new ResourceLocation("textures/gui/recipe_button.png");
        MutableLong startReload = new MutableLong(-1L);
        MutableLong endReload = new MutableLong(-1L);
        PRE_UPDATE_RECIPES.register(recipeManager -> RoughlyEnoughItemsCoreClient.reloadPlugins(startReload, ReloadStage.START));
        ClientRecipeUpdateEvent.EVENT.register(recipeManager -> RoughlyEnoughItemsCoreClient.reloadPlugins(endReload, Platform.isFabric() ? ReloadStage.END : null));
        ClientGuiEvent.INIT_POST.register((screen, access) -> {
            REIRuntimeImpl.getInstance().setPreviousScreen(screen);
            if (ConfigObject.getInstance().doesDisableRecipeBook() && screen instanceof AbstractContainerScreen) {
                access.getRenderables().removeIf(widget -> {
                    Widget button$temp = widget;
                    if (!(button$temp instanceof ImageButton)) return false;
                    ImageButton button = (ImageButton)button$temp;
                    if (!button.f_94223_.equals((Object)recipeButtonTex)) return false;
                    return true;
                });
                access.getNarratables().removeIf(widget -> {
                    NarratableEntry button$temp = widget;
                    if (!(button$temp instanceof ImageButton)) return false;
                    ImageButton button = (ImageButton)button$temp;
                    if (!button.f_94223_.equals((Object)recipeButtonTex)) return false;
                    return true;
                });
                screen.m_6702_().removeIf(widget -> {
                    GuiEventListener button$temp = widget;
                    if (!(button$temp instanceof ImageButton)) return false;
                    ImageButton button = (ImageButton)button$temp;
                    if (!button.f_94223_.equals((Object)recipeButtonTex)) return false;
                    return true;
                });
            }
        });
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = true;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().m_6375_(mouseX, mouseY, button)) {
                if (button == 0) {
                    screen.m_7897_(true);
                }
                this.resetFocused(screen);
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register((minecraftClient, screen, mouseX, mouseY, button) -> {
            isLeftMousePressed = false;
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            this.resetFocused(screen);
            if (REIRuntime.getInstance().isOverlayVisible() && RoughlyEnoughItemsCoreClient.getOverlay().m_6348_(mouseX, mouseY, button) && this.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register((minecraftClient, screen, mouseX, mouseY, amount) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            this.resetFocused(screen);
            if (REIRuntime.getInstance().isOverlayVisible() && RoughlyEnoughItemsCoreClient.getOverlay().m_6050_(mouseX, mouseY, amount) && this.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.CHAR_TYPED_PRE.register((minecraftClient, screen, character, keyCode) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().m_5534_(character, keyCode) && this.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientGuiEvent.RENDER_POST.register((screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return;
            }
            this.resetFocused(screen);
            RoughlyEnoughItemsCoreClient.getOverlay().m_6305_(matrices, mouseX, mouseY, delta);
            ((ScreenOverlayImpl)RoughlyEnoughItemsCoreClient.getOverlay()).lateRender(matrices, mouseX, mouseY, delta);
            this.resetFocused(screen);
        });
        ClientScreenInputEvent.MOUSE_DRAGGED_PRE.register((minecraftClient, screen, mouseX1, mouseY1, button, mouseX2, mouseY2) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().m_7979_(mouseX1, mouseY1, button, mouseX2, mouseY2) && this.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientScreenInputEvent.KEY_PRESSED_PRE.register((minecraftClient, screen, i, i1, i2) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            if (screen instanceof AbstractContainerScreen && ConfigObject.getInstance().doesDisableRecipeBook() && ConfigObject.getInstance().doesFixTabCloseContainer() && i == 258 && minecraftClient.f_91066_.f_92092_.m_90832_(i, i1)) {
                minecraftClient.f_91074_.m_6915_();
                return EventResult.interruptFalse();
            }
            if (screen.m_7222_() != null && screen.m_7222_() instanceof EditBox || screen.m_7222_() instanceof RecipeBookComponent && ((RecipeBookComponent)screen.m_7222_()).f_100281_ != null && ((RecipeBookComponent)screen.m_7222_()).f_100281_.m_93696_()) {
                return EventResult.pass();
            }
            this.resetFocused(screen);
            if (RoughlyEnoughItemsCoreClient.getOverlay().m_7933_(i, i1, i2) && this.resetFocused(screen)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    private boolean resetFocused(Screen screen) {
        if (screen.m_7222_() instanceof ScreenOverlay || screen.m_7222_() == screen) {
            screen.m_7522_(null);
        }
        return true;
    }

    @ApiStatus.Internal
    public static void reloadPlugins(MutableLong lastReload, @Nullable ReloadStage start) {
        if (lastReload != null) {
            if (lastReload.getValue() > 0L && System.currentTimeMillis() - lastReload.getValue() <= 5000L) {
                RoughlyEnoughItemsCore.LOGGER.warn("Suppressing Reload Plugins!");
                return;
            }
            lastReload.setValue(System.currentTimeMillis());
        }
        if (ConfigObject.getInstance().doesRegisterRecipesInAnotherThread()) {
            CompletableFuture.runAsync(() -> RoughlyEnoughItemsCore._reloadPlugins(start), RELOAD_PLUGINS);
        } else {
            RoughlyEnoughItemsCore._reloadPlugins(start);
        }
    }
}

