/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import com.google.common.collect.AbstractIterator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetHolder;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class Widgets {
    private Widgets() {
    }

    public static Widget createDrawableWidget(DrawableConsumer drawable) {
        return ClientInternals.getWidgetsProvider().createDrawableWidget(drawable);
    }

    public static Widget wrapVanillaWidget(GuiEventListener element) {
        return new VanillaWrappedWidget(element);
    }

    public static WidgetWithBounds withTranslate(Widget widget, double x, double y, double z) {
        return Widgets.withTranslate(widget, Matrix4f.m_27653_((float)((float)x), (float)((float)y), (float)((float)z)));
    }

    public static WidgetWithBounds withTranslate(Widget widget, Matrix4f translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, () -> translate);
    }

    public static <T extends Widget> WidgetWithBounds withTranslate(T widget, Function<T, Matrix4f> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, () -> (Matrix4f)translate.apply(widget));
    }

    public static WidgetWithBounds withTranslate(Widget widget, Supplier<Matrix4f> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return new WidgetWithBoundsWithTranslate(widgetWithBounds, translate);
    }

    public static WidgetWithBounds wrapRenderer(Rectangle bounds, Renderer renderer) {
        Renderer renderer2 = renderer;
        if (renderer2 instanceof Widget) {
            Widget widget = (Widget)renderer2;
            return Widgets.wrapWidgetWithBounds(widget, bounds);
        }
        return new RendererWrappedWidget(renderer, bounds);
    }

    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget) {
        return Widgets.wrapWidgetWithBounds(widget, null);
    }

    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget, Rectangle bounds) {
        Widget widget2 = widget;
        if (widget2 instanceof WidgetWithBounds) {
            WidgetWithBounds withBounds = (WidgetWithBounds)widget2;
            return withBounds;
        }
        if (bounds == null) {
            return new DelegateWidget(widget);
        }
        return new DelegateWidgetWithBounds(widget, bounds);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds) {
        return Widgets.createTexturedWidget(identifier, bounds, 0.0f, 0.0f);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, 0.0f, 0.0f, width, height);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds, float u, float v) {
        return Widgets.createTexturedWidget(identifier, bounds, u, v, 256, 256);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, float u, float v, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, 256, 256);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds, float u, float v, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, bounds.width, bounds.height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, Rectangle bounds, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(ResourceLocation identifier, int x, int y, float u, float v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createTexturedConsumer(identifier, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight));
    }

    public static Widget createFilledRectangle(Rectangle rectangle, int color) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createFillRectangleConsumer(rectangle, color));
    }

    public static Label createLabel(Point point, Component text) {
        return ClientInternals.getWidgetsProvider().createLabel(point, (FormattedText)text);
    }

    public static Label createClickableLabel(Point point, Component text, @Nullable Consumer<Label> onClick) {
        return Widgets.createLabel(point, text).clickable().onClick(onClick);
    }

    public static Arrow createArrow(Point point) {
        return ClientInternals.getWidgetsProvider().createArrow(new Rectangle(point, new Dimension(24, 17)));
    }

    public static BurningFire createBurningFire(Point point) {
        return ClientInternals.getWidgetsProvider().createBurningFire(new Rectangle(point, new Dimension(14, 14)));
    }

    public static Widget createSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public static Widget createResultSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 5, point.y - 5, 26, 26));
    }

    public static Panel createCategoryBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle);
    }

    public static Panel createCategoryBase(Rectangle rectangle, int color) {
        return Widgets.createCategoryBase(rectangle).color(color);
    }

    public static Panel createRecipeBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldRecipeBaseRender);
    }

    public static Panel createRecipeBase(Rectangle rectangle, int color) {
        return Widgets.createRecipeBase(rectangle).color(color);
    }

    private static boolean shouldRecipeBaseRender(Panel panel) {
        return ConfigObject.getInstance().getRecipeBorderType().isRendering() && ClientInternals.getWidgetsProvider().isRenderingPanel(panel);
    }

    public static Panel createSlotBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(-66).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldSlotBaseRender(Panel panel) {
        return true;
    }

    public static Panel createSlotBase(Rectangle rectangle, int color) {
        return Widgets.createSlotBase(rectangle).color(color);
    }

    public static Slot createSlot(Point point) {
        return ClientInternals.getWidgetsProvider().createSlot(point);
    }

    public static Slot createSlot(Rectangle bounds) {
        return ClientInternals.getWidgetsProvider().createSlot(bounds);
    }

    public static Button createButton(Rectangle bounds, Component text) {
        return ClientInternals.getWidgetsProvider().createButton(bounds, text);
    }

    public static void produceClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public static <T> Iterable<T> walk(final Iterable<? extends GuiEventListener> listeners, final Predicate<GuiEventListener> predicate) {
        return () -> new AbstractIterator<T>(){
            Stack<Iterator<? extends GuiEventListener>> stack = new Stack();
            {
                this.stack.push(listeners.iterator());
            }

            protected T computeNext() {
                while (!this.stack.empty()) {
                    WidgetHolder holder;
                    Object children;
                    Iterator<? extends GuiEventListener> peek = this.stack.peek();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (this.stack.isEmpty()) break;
                    GuiEventListener listener = peek.next();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (predicate.test(listener)) {
                        return listener;
                    }
                    GuiEventListener guiEventListener = listener;
                    if (guiEventListener instanceof ContainerEventHandler) {
                        ContainerEventHandler handler = (ContainerEventHandler)guiEventListener;
                        children = handler.m_6702_();
                        if (children.isEmpty()) continue;
                        this.stack.push(children.iterator());
                        continue;
                    }
                    children = listener;
                    if (!(children instanceof WidgetHolder) || (children = (holder = (WidgetHolder)children).children()).isEmpty()) continue;
                    this.stack.push(children.iterator());
                }
                return this.endOfData();
            }
        };
    }

    private static class VanillaWrappedWidget
    extends Widget {
        private GuiEventListener element;

        public VanillaWrappedWidget(GuiEventListener element) {
            this.element = Objects.requireNonNull(element);
            this.m_7522_(element);
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            GuiEventListener guiEventListener = this.element;
            if (guiEventListener instanceof GuiComponent) {
                GuiComponent component = (GuiComponent)guiEventListener;
                component.m_93250_(this.getZ());
            }
            if ((guiEventListener = this.element) instanceof net.minecraft.client.gui.components.Widget) {
                net.minecraft.client.gui.components.Widget widget = (net.minecraft.client.gui.components.Widget)guiEventListener;
                widget.m_6305_(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.element);
        }

        @Override
        @Nullable
        public GuiEventListener m_7222_() {
            return this.element;
        }

        @Override
        public void m_7522_(@Nullable GuiEventListener guiEventListener) {
            if (guiEventListener == this.element) {
                super.m_7522_(this.element);
            } else {
                GuiEventListener guiEventListener2 = this.element;
                if (guiEventListener2 instanceof ContainerEventHandler) {
                    ContainerEventHandler handler = (ContainerEventHandler)guiEventListener2;
                    handler.m_7522_(guiEventListener);
                }
            }
        }

        @Override
        public boolean m_7282_() {
            return true;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.element.m_5953_(mouseX, mouseY);
        }
    }

    private static class WidgetWithBoundsWithTranslate
    extends DelegateWidget {
        private final Supplier<Matrix4f> translate;

        private WidgetWithBoundsWithTranslate(WidgetWithBounds widget, Supplier<Matrix4f> translate) {
            super(widget);
            this.translate = translate;
        }

        @Override
        public void m_6305_(PoseStack poseStack, int i, int j, float f) {
            poseStack.m_85836_();
            poseStack.m_85850_().m_85861_().m_27644_(this.translate.get());
            Vector4f mouse = this.transformMouse(i, j);
            super.m_6305_(poseStack, (int)mouse.m_123601_(), (int)mouse.m_123615_(), f);
            poseStack.m_85849_();
        }

        private Vector4f transformMouse(double mouseX, double mouseY) {
            Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            mouse.m_123607_(this.translate.get());
            return mouse;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            Vector4f mouse = this.transformMouse(mouseX, mouseY);
            return super.containsMouse(mouse.m_123601_(), mouse.m_123615_());
        }

        public boolean m_6375_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_6375_((double)mouse.m_123601_(), (double)mouse.m_123615_(), i);
        }

        public boolean m_6348_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_6348_((double)mouse.m_123601_(), (double)mouse.m_123615_(), i);
        }

        public boolean m_7979_(double d, double e, int i, double f, double g) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_7979_((double)mouse.m_123601_(), (double)mouse.m_123615_(), i, f, g);
        }

        public boolean m_6050_(double d, double e, double f) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_6050_((double)mouse.m_123601_(), (double)mouse.m_123615_(), f);
        }
    }

    private static class RendererWrappedWidget
    extends WidgetWithBounds {
        private final Renderer renderer;
        private final Rectangle bounds;

        public RendererWrappedWidget(Renderer renderer, Rectangle bounds) {
            this.renderer = Objects.requireNonNull(renderer);
            this.bounds = Objects.requireNonNull(bounds);
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            this.renderer.render(matrices, this.getBounds(), mouseX, mouseY, delta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            Renderer renderer = this.renderer;
            if (renderer instanceof GuiEventListener) {
                GuiEventListener listener = (GuiEventListener)renderer;
                return Collections.singletonList(listener);
            }
            return Collections.emptyList();
        }

        @Override
        public void setZ(int z) {
            this.renderer.setZ(z);
        }

        @Override
        public int getZ() {
            return this.renderer.getZ();
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    private static class DelegateWidgetWithBounds
    extends DelegateWidget {
        private final Rectangle bounds;

        public DelegateWidgetWithBounds(Widget widget, Rectangle bounds) {
            super(widget);
            this.bounds = bounds;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

