/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.display;

import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.Identifiable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public interface DisplayCategory<T extends Display>
extends Identifiable {
    public Renderer getIcon();

    public Component getTitle();

    @ApiStatus.OverrideOnly
    default public DisplayRenderer getDisplayRenderer(T display) {
        return SimpleDisplayRenderer.from(display.getInputEntries(), display.getOutputEntries());
    }

    @ApiStatus.OverrideOnly
    default public List<Widget> setupDisplay(T display, Rectangle bounds) {
        return Collections.singletonList(Widgets.createRecipeBase(bounds));
    }

    default public int getDisplayHeight() {
        return 66;
    }

    default public int getDisplayWidth(T display) {
        return 150;
    }

    default public int getMaximumDisplaysPerPage() {
        return 99;
    }

    default public int getFixedDisplaysPerPage() {
        return -1;
    }

    public CategoryIdentifier<? extends T> getCategoryIdentifier();

    @Override
    default public ResourceLocation getIdentifier() {
        return this.getCategoryIdentifier().getIdentifier();
    }
}

