/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.transfer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Supplier;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface TransferHandler
extends Comparable<TransferHandler> {
    default public double getPriority() {
        return 0.0;
    }

    public Result handle(Context var1);

    @Override
    default public int compareTo(TransferHandler o) {
        return Double.compare(this.getPriority(), o.getPriority());
    }

    @ApiStatus.Internal
    public static final class ContextImpl
    implements Context {
        private boolean actuallyCrafting;
        private AbstractContainerScreen<?> containerScreen;
        private Supplier<Display> recipeDisplaySupplier;

        private ContextImpl(boolean actuallyCrafting, AbstractContainerScreen<?> containerScreen, Supplier<Display> recipeDisplaySupplier) {
            this.actuallyCrafting = actuallyCrafting;
            this.containerScreen = containerScreen;
            this.recipeDisplaySupplier = recipeDisplaySupplier;
        }

        @Override
        public boolean isActuallyCrafting() {
            return this.actuallyCrafting;
        }

        @Override
        public AbstractContainerScreen<?> getContainerScreen() {
            return this.containerScreen;
        }

        @Override
        public Display getDisplay() {
            return this.recipeDisplaySupplier.get();
        }
    }

    @ApiStatus.Internal
    public static final class ResultImpl
    implements Result {
        private boolean successful;
        private boolean applicable;
        private boolean returningToScreen;
        private boolean blocking;
        private Component error;
        private IntList integers = new IntArrayList();
        private int color;

        private ResultImpl() {
            this(true, true);
        }

        public ResultImpl(boolean applicable) {
            this(false, applicable);
        }

        public ResultImpl(boolean successful, boolean applicable) {
            this.successful = successful;
            this.applicable = applicable;
        }

        public ResultImpl(Component error, IntList integers, int color) {
            this.successful = false;
            this.applicable = true;
            this.error = error;
            if (integers != null) {
                this.integers = integers;
            }
            this.color = color;
        }

        @Override
        public Result blocksFurtherHandling(boolean returningToScreen) {
            this.blocking = true;
            this.returningToScreen = returningToScreen;
            return this;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public boolean isBlocking() {
            return this.successful || this.blocking;
        }

        @Override
        public boolean isApplicable() {
            return this.applicable;
        }

        @Override
        public boolean isReturningToScreen() {
            return this.returningToScreen;
        }

        @Override
        public Component getError() {
            return this.error;
        }

        @Override
        public IntList getIntegers() {
            return this.integers;
        }
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public static Context create(boolean actuallyCrafting, @Nullable AbstractContainerScreen<?> containerScreen, Display display) {
            return new ContextImpl(actuallyCrafting, containerScreen, () -> display);
        }

        default public Minecraft getMinecraft() {
            return Minecraft.m_91087_();
        }

        public boolean isActuallyCrafting();

        public Display getDisplay();

        @Nullable
        public AbstractContainerScreen<?> getContainerScreen();

        @Nullable
        default public AbstractContainerMenu getMenu() {
            return this.getContainerScreen() == null ? null : this.getContainerScreen().m_6262_();
        }
    }

    @ApiStatus.NonExtendable
    public static interface Result {
        public static Result createSuccessful() {
            return new ResultImpl();
        }

        public static Result createNotApplicable() {
            return new ResultImpl(false);
        }

        public static Result createFailed(Component error) {
            return new ResultImpl(error, (IntList)new IntArrayList(), 1744764928);
        }

        public static Result createFailedCustomButtonColor(Component error, int color) {
            return new ResultImpl(error, (IntList)new IntArrayList(), color);
        }

        public static Result createFailed(Component error, IntList redSlots) {
            return new ResultImpl(error, redSlots, 1744764928);
        }

        public static Result createFailedCustomButtonColor(Component error, IntList redSlots, int color) {
            return new ResultImpl(error, redSlots, color);
        }

        default public Result blocksFurtherHandling() {
            return this.blocksFurtherHandling(true);
        }

        public Result blocksFurtherHandling(boolean var1);

        public int getColor();

        public boolean isSuccessful();

        public boolean isBlocking();

        public boolean isReturningToScreen();

        public boolean isApplicable();

        public Component getError();

        public IntList getIntegers();
    }
}

