/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.util;

import dev.architectury.fluid.FluidStack;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.entry.type.BuiltinClientEntryTypes;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;

public final class ClientEntryStacks {
    private ClientEntryStacks() {
    }

    public static EntryStack<?> of(Renderer renderer) {
        Renderer renderer2 = renderer;
        if (renderer2 instanceof EntryStack) {
            EntryStack stack = (EntryStack)renderer2;
            return stack;
        }
        return EntryStack.of(BuiltinClientEntryTypes.RENDERING, renderer);
    }

    public static <T> EntryStack<T> setNotRenderer(EntryStack<? extends T> stack) {
        return ClientEntryStacks.setRenderer(stack, EntryRenderer.empty());
    }

    public static <T> EntryStack<T> setRenderer(EntryStack<? extends T> stack, EntryRenderer<? extends T> renderer) {
        return stack.setting(EntryStack.Settings.RENDERER, s -> renderer).cast();
    }

    public static <T> EntryStack<T> setRenderer(EntryStack<? extends T> stack, Function<EntryStack<T>, EntryRenderer<? extends T>> rendererProvider) {
        return stack.setting(EntryStack.Settings.RENDERER, rendererProvider).cast();
    }

    public static <T> EntryStack<T> setTooltipProcessor(EntryStack<? extends T> stack, BiFunction<EntryStack<T>, Tooltip, Tooltip> processor) {
        return stack.setting(EntryStack.Settings.TOOLTIP_PROCESSOR, processor).cast();
    }

    public static EntryStack<FluidStack> setFluidRenderRatio(EntryStack<FluidStack> stack, float ratio) {
        return stack.setting(EntryStack.Settings.FLUID_RENDER_RATIO, Float.valueOf(ratio));
    }
}

