/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer.info;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.RecipeFinderPopulator;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.transfer.info.clean.InputCleanHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public interface MenuInfo<T extends AbstractContainerMenu, D extends Display>
extends MenuInfoProvider<T, D> {
    @Override
    default public Optional<MenuInfo<T, D>> provide(CategoryIdentifier<D> categoryId, Class<T> menuClass) {
        return Optional.of(this);
    }

    public RecipeFinderPopulator<T, D> getRecipeFinderPopulator();

    public InputCleanHandler<T, D> getInputCleanHandler();

    public Iterable<SlotAccessor> getInputSlots(MenuInfoContext<T, ?, D> var1);

    public Iterable<SlotAccessor> getInventorySlots(MenuInfoContext<T, ?, D> var1);

    default public void markDirty(MenuInfoContext<T, ? extends ServerPlayer, D> context) {
        ((ServerPlayer)context.getPlayerEntity()).m_150109_().m_6596_();
        context.getMenu().m_150429_();
    }

    default public void validate(MenuInfoContext<T, ?, D> context) throws MenuTransferException {
    }

    default public List<List<ItemStack>> getInputs(MenuInfoContext<T, ?, D> context) {
        if (context.getDisplay() == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(context.getDisplay().getInputEntries(), inputEntry -> CollectionUtils.filterAndMap(inputEntry, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    default public CompoundTag save(MenuSerializationContext<T, ?, D> context, D display) {
        return DisplaySerializerRegistry.getInstance().save(display, new CompoundTag());
    }

    default public D read(MenuSerializationContext<T, ?, D> context, CompoundTag tag) {
        return DisplaySerializerRegistry.getInstance().read(context.getCategoryIdentifier(), tag);
    }
}

