/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.util;

import com.google.common.collect.ImmutableList;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public final class EntryIngredients {
    private EntryIngredients() {
    }

    public static EntryIngredient of(ItemLike stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(ItemLike stack, int amount) {
        return EntryIngredient.of(EntryStacks.of(stack, amount));
    }

    public static EntryIngredient of(ItemStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static EntryIngredient of(Fluid fluid) {
        return EntryIngredient.of(EntryStacks.of(fluid));
    }

    public static EntryIngredient of(Fluid fluid, long amount) {
        return EntryIngredient.of(EntryStacks.of(fluid, amount));
    }

    public static EntryIngredient of(FluidStack stack) {
        return EntryIngredient.of(EntryStacks.of(stack));
    }

    public static <T> EntryIngredient of(EntryType<T> type, Collection<T> values) {
        return EntryIngredients.of(type.getDefinition(), values);
    }

    public static <T> EntryIngredient of(EntryDefinition<T> definition, Collection<T> values) {
        if (values.size() == 0) {
            return EntryIngredient.empty();
        }
        if (values.size() == 1) {
            return EntryIngredient.of(EntryStack.of(definition, values.iterator().next()));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(values.size());
        for (T value : values) {
            result.add((EntryStack<?>)EntryStack.of(definition, value));
        }
        return result.build();
    }

    public static EntryIngredient ofItems(Collection<ItemLike> stacks) {
        return EntryIngredients.ofItems(stacks, 1);
    }

    public static EntryIngredient ofItems(Collection<ItemLike> stacks, int amount) {
        if (stacks.size() == 0) {
            return EntryIngredient.empty();
        }
        if (stacks.size() == 1) {
            return EntryIngredient.of(EntryStacks.of(stacks.iterator().next(), amount));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(stacks.size());
        for (ItemLike stack : stacks) {
            result.add((EntryStack<?>)EntryStacks.of(stack, amount));
        }
        return result.build();
    }

    public static EntryIngredient ofItemStacks(Collection<ItemStack> stacks) {
        return EntryIngredients.of(VanillaEntryTypes.ITEM, stacks);
    }

    public static EntryIngredient ofIngredient(Ingredient ingredient) {
        if (ingredient.m_43947_()) {
            return EntryIngredient.empty();
        }
        ItemStack[] matchingStacks = ingredient.m_43908_();
        if (matchingStacks.length == 0) {
            return EntryIngredient.empty();
        }
        if (matchingStacks.length == 1) {
            return EntryIngredient.of(EntryStacks.of(matchingStacks[0]));
        }
        EntryIngredient.Builder result = EntryIngredient.builder(matchingStacks.length);
        for (ItemStack matchingStack : matchingStacks) {
            if (matchingStack.m_41619_()) continue;
            result.add((EntryStack<?>)EntryStacks.of(matchingStack));
        }
        return result.build();
    }

    public static List<EntryIngredient> ofIngredients(List<Ingredient> ingredients) {
        if (ingredients.size() == 0) {
            return Collections.emptyList();
        }
        if (ingredients.size() == 1) {
            Ingredient ingredient = ingredients.get(0);
            if (ingredient.m_43947_()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(EntryIngredients.ofIngredient(ingredient));
        }
        boolean emptyFlag = true;
        ArrayList<EntryIngredient> result = new ArrayList<EntryIngredient>(ingredients.size());
        for (int i = ingredients.size() - 1; i >= 0; --i) {
            Ingredient ingredient = ingredients.get(i);
            if (emptyFlag && ingredient.m_43947_()) continue;
            result.add(0, EntryIngredients.ofIngredient(ingredient));
            emptyFlag = false;
        }
        return ImmutableList.copyOf(result);
    }

    public static <T> boolean testFuzzy(EntryIngredient ingredient, EntryStack<T> stack) {
        for (EntryStack ingredientStack : ingredient) {
            if (!EntryStacks.equalsFuzzy(ingredientStack, stack)) continue;
            return true;
        }
        return false;
    }

    public static ListTag save(List<EntryIngredient> ingredients) {
        ListTag listTag = new ListTag();
        for (EntryIngredient ingredient : ingredients) {
            listTag.add((Object)ingredient.save());
        }
        return listTag;
    }

    public static List<EntryIngredient> read(ListTag listTag) {
        if (listTag.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (Tag tag : listTag) {
            ingredients.add((Object)EntryIngredient.read((ListTag)tag));
        }
        return ingredients.build();
    }
}

