/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.AbstractFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringResult;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchFilteringRule
extends AbstractFilteringRule<SearchFilteringRule> {
    private SearchFilter filter;
    private boolean show;

    public SearchFilteringRule() {
    }

    public SearchFilteringRule(SearchFilter filter, boolean show) {
        this.filter = filter;
        this.show = show;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("filter", this.filter.getFilter());
        tag.m_128379_("show", this.show);
        return tag;
    }

    @Override
    public SearchFilteringRule createFromTag(CompoundTag tag) {
        String filter = tag.m_128461_("filter");
        boolean show = tag.m_128471_("show");
        return new SearchFilteringRule(SearchProvider.getInstance().createFilter(filter), show);
    }

    @Override
    public FilteringResult processFilteredStacks(FilteringContext context) {
        ArrayList completableFutures = Lists.newArrayList();
        this.processList(context.getUnsetStacks(), completableFutures);
        if (this.show) {
            this.processList(context.getHiddenStacks(), completableFutures);
        } else {
            this.processList(context.getShownStacks(), completableFutures);
        }
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        FilteringResult result = FilteringResult.create();
        for (CompletableFuture future : completableFutures) {
            List now = future.getNow(null);
            if (now == null) continue;
            if (this.show) {
                result.show(now);
                continue;
            }
            result.hide(now);
        }
        return result;
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule(SearchFilter.matchAll(), true);
    }

    private void processList(Collection<EntryStack<?>> stacks, List<CompletableFuture<List<EntryStack<?>>>> completableFutures) {
        for (Iterable iterable : CollectionUtils.partition((List)stacks, 100)) {
            completableFutures.add(CompletableFuture.supplyAsync(() -> {
                ArrayList output = Lists.newArrayList();
                for (EntryStack stack : partitionStacks) {
                    if (!this.filter.test(stack)) continue;
                    output.add(stack);
                }
                return output;
            }));
        }
    }

    @Override
    public Component getTitle() {
        return new TranslatableComponent("rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public Component getSubtitle() {
        return new TranslatableComponent("rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    public Optional<BiFunction<FilteringEntry, Screen, Screen>> createEntryScreen() {
        return Optional.of((entry, screen) -> new FilteringRuleOptionsScreen<SearchFilteringRule>(entry, this, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            {
                this.entry = null;
                this.show = null;
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)new TranslatableComponent("rule.roughlyenoughitems.filtering.search.filter").m_130940_(ChatFormatting.GRAY));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.f_96543_ - 36, this.rule, widget -> {
                    widget.m_94199_(9999);
                    if (this.entry != null) {
                        widget.m_94144_(this.entry.getWidget().m_94155_());
                    } else {
                        widget.m_94144_(((SearchFilteringRule)this.rule).filter.getFilter());
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)new TranslatableComponent("rule.roughlyenoughitems.filtering.search.show").m_130940_(ChatFormatting.GRAY));
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.f_96543_ - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, bool -> new TranslatableComponent("rule.roughlyenoughitems.filtering.search.show." + bool));
                entryConsumer.accept(this.show);
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).filter = SearchProvider.getInstance().createFilter(this.entry.getWidget().m_94155_());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        });
    }
}

