/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.forge.ScreenOverlayImplImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import me.shedaniel.rei.impl.common.util.Weather;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ScreenOverlayImpl
extends ScreenOverlay {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static final List<Runnable> AFTER_RENDER = Lists.newArrayList();
    private static final EntryListWidget ENTRY_LIST_WIDGET = new EntryListWidget();
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReload = false;
    private Rectangle bounds;
    private Window window;
    private Button leftButton;
    private Button rightButton;
    private Widget configButton;
    private CurrentDraggingStack draggingStack = new CurrentDraggingStack();
    @Nullable
    private OverlayMenu overlayMenu = null;

    public static EntryListWidget getEntryListWidget() {
        return ENTRY_LIST_WIDGET;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public static ScreenOverlayImpl getInstance() {
        return (ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get();
    }

    public void tick() {
        if (REIRuntimeImpl.getSearchField() != null) {
            REIRuntimeImpl.getSearchField().tick();
            if (Minecraft.m_91087_().f_91074_ != null && !PluginManager.areAnyReloading()) {
                CraftableFilter.INSTANCE.tick();
            }
        }
    }

    public boolean isMenuOpened(UUID uuid) {
        return this.overlayMenu != null && this.overlayMenu.uuid.equals(uuid);
    }

    public boolean isAnyMenuOpened() {
        return this.overlayMenu != null;
    }

    public boolean isMenuInBounds(UUID uuid) {
        return this.isMenuOpened(uuid) && this.overlayMenu.inBounds.test(PointHelper.ofMouse());
    }

    private void proceedOpenMenu(UUID uuid, Runnable runnable) {
        this.proceedOpenMenuOrElse(uuid, runnable, menu -> {});
    }

    private void proceedOpenMenuOrElse(UUID uuid, Runnable runnable, Consumer<OverlayMenu> orElse) {
        if (this.overlayMenu == null || !this.overlayMenu.uuid.equals(uuid)) {
            this.closeOverlayMenu();
            runnable.run();
        } else {
            orElse.accept(this.overlayMenu);
        }
    }

    public void openMenu(UUID uuid, Menu menu) {
        this.openMenu(uuid, menu, point -> false, point -> true);
    }

    public void openMenu(UUID uuid, Menu menu, Predicate<Point> or, Predicate<Point> and) {
        this.overlayMenu = new OverlayMenu(uuid, menu, Widgets.withTranslate(menu, 0.0, 0.0, 400.0), or, and);
    }

    @ApiStatus.Internal
    @Nullable
    public Menu getOverlayMenu() {
        if (this.isMenuOpened(Menu.SUBSETS)) {
            return this.overlayMenu.menu;
        }
        throw new IllegalStateException("Subsets menu accessed when subsets are not opened!");
    }

    @Override
    @ApiStatus.Internal
    public void closeOverlayMenu() {
        OverlayMenu tmpOverlayMenu = this.overlayMenu;
        if (tmpOverlayMenu != null) {
            AFTER_RENDER.add(() -> this.widgets.remove(tmpOverlayMenu.wrappedMenu));
        }
        this.overlayMenu = null;
    }

    @Override
    public void queueReloadOverlay() {
        this.shouldReload = true;
    }

    @Override
    public DraggingContext<?> getDraggingContext() {
        return this.draggingStack;
    }

    public void init(boolean useless) {
        this.init();
    }

    public void init() {
        Argument.SEARCH_CACHE.clear();
        this.draggingStack.set(DraggableStackProvider.from(() -> ScreenRegistry.getInstance().getDraggableProviders()), DraggableStackVisitor.from(() -> ScreenRegistry.getInstance().getDraggableVisitors()));
        this.shouldReload = false;
        this.m_6702_().clear();
        this.closeOverlayMenu();
        this.window = Minecraft.m_91087_().m_91268_();
        this.bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), Minecraft.m_91087_().f_91080_);
        this.widgets.add(ENTRY_LIST_WIDGET);
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            ScreenOverlayImpl.favoritesListWidget.favoritePanel.resetRows();
            this.widgets.add(favoritesListWidget);
        }
        ENTRY_LIST_WIDGET.updateArea(REIRuntimeImpl.getSearchField() == null ? "" : REIRuntimeImpl.getSearchField().getText());
        REIRuntimeImpl.getSearchField().getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(REIRuntimeImpl.getSearchField());
        REIRuntimeImpl.getSearchField().setResponder(s -> ENTRY_LIST_WIDGET.updateSearch((String)s, false));
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton = Widgets.createButton(new Rectangle(this.bounds.x, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (Component)new TranslatableComponent("text.rei.left_arrow")).onClick(button -> {
                ENTRY_LIST_WIDGET.previousPage();
                if (ENTRY_LIST_WIDGET.getPage() < 0) {
                    ENTRY_LIST_WIDGET.setPage(ENTRY_LIST_WIDGET.getTotalPages() - 1);
                }
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLine((Component)new TranslatableComponent("text.rei.previous_page")).focusable(false);
            this.widgets.add(this.leftButton);
            this.rightButton = Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 18, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (Component)new TranslatableComponent("text.rei.right_arrow")).onClick(button -> {
                ENTRY_LIST_WIDGET.nextPage();
                if (ENTRY_LIST_WIDGET.getPage() >= ENTRY_LIST_WIDGET.getTotalPages()) {
                    ENTRY_LIST_WIDGET.setPage(0);
                }
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLine((Component)new TranslatableComponent("text.rei.next_page")).focusable(false);
            this.widgets.add(this.rightButton);
        }
        Rectangle configButtonArea = this.getConfigButtonArea();
        this.configButton = InternalWidgets.wrapLateRenderable(Widgets.withTranslate(InternalWidgets.concatWidgets(Widgets.createButton(configButtonArea, NarratorChatListener.f_93310_).onClick(button -> {
            if (Screen.m_96638_() || Screen.m_96637_()) {
                ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                return;
            }
            ConfigManager.getInstance().openConfigScreen(REIRuntime.getInstance().getPreviousScreen());
        }).onRender((matrices, button) -> {
            if (ClientHelper.getInstance().isCheating() && ClientHelperImpl.getInstance().hasOperatorPermission()) {
                button.setTint(ClientHelperImpl.getInstance().hasPermissionToUsePackets() ? 721354752 : 1476440063);
            } else {
                button.removeTint();
            }
        }).focusable(false).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipSupplier(button -> {
            ArrayList<Object> tooltips = new ArrayList<Object>();
            tooltips.add(new TranslatableComponent("text.rei.config_tooltip"));
            tooltips.add(new ImmutableTextComponent("  "));
            if (!ClientHelper.getInstance().isCheating()) {
                tooltips.add(new TranslatableComponent("text.rei.cheating_disabled"));
            } else if (!ClientHelperImpl.getInstance().hasOperatorPermission()) {
                if (this.minecraft.f_91072_.m_105290_()) {
                    tooltips.add(new TranslatableComponent("text.rei.cheating_limited_creative_enabled"));
                } else {
                    tooltips.add(new TranslatableComponent("text.rei.cheating_enabled_no_perms"));
                }
            } else if (ClientHelperImpl.getInstance().hasPermissionToUsePackets()) {
                tooltips.add(new TranslatableComponent("text.rei.cheating_enabled"));
            } else {
                tooltips.add(new TranslatableComponent("text.rei.cheating_limited_enabled"));
            }
            return tooltips.toArray(new Component[0]);
        }), Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            helper.m_93250_(helper.m_93252_() + 1);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CHEST_GUI_TEXTURE);
            helper.m_93228_(matrices, configButtonArea.x + 3, configButtonArea.y + 3, 0, 0, 14, 14);
        })), 0.0, 0.0, 600.0));
        this.widgets.add(this.configButton);
        Rectangle subsetsButtonBounds = this.getSubsetsButtonBounds();
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            this.widgets.add(InternalWidgets.wrapLateRenderable(Widgets.withTranslate(Widgets.createButton(subsetsButtonBounds, (Component)((Boolean)ClientHelperImpl.getInstance().isAprilFools.m_13971_() != false ? new TranslatableComponent("text.rei.tiny_potato") : new TranslatableComponent("text.rei.subsets"))).onClick(button -> this.proceedOpenMenuOrElse(Menu.SUBSETS, () -> this.openMenu(Menu.SUBSETS, Menu.createSubsetsMenuFromRegistry(new Point(subsetsButtonBounds.x, subsetsButtonBounds.getMaxY())), point -> true, point -> true), menu -> this.closeOverlayMenu())), 0.0, 0.0, 600.0)));
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), NarratorChatListener.f_93310_, label -> {
                ENTRY_LIST_WIDGET.setPage(0);
                ENTRY_LIST_WIDGET.updateEntriesPosition();
            }).tooltipLine(I18n.m_118938_((String)"text.rei.go_back_first_page", (Object[])new Object[0])).focusable(false).onRender((matrices, label) -> {
                label.setClickable(ENTRY_LIST_WIDGET.getTotalPages() > 1);
                label.setMessage((FormattedText)new TextComponent(String.format("%s/%s", ENTRY_LIST_WIDGET.getPage() + 1, Math.max(ENTRY_LIST_WIDGET.getTotalPages(), 1))));
            }).rainbow((double)new Random().nextFloat() < 1.0E-4 || (Boolean)ClientHelperImpl.getInstance().isAprilFools.m_13971_() != false));
        }
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            Rectangle area = this.getCraftableToggleArea();
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            ItemStack icon = new ItemStack((ItemLike)Blocks.f_50091_);
            this.widgets.add(Widgets.withTranslate(InternalWidgets.wrapLateRenderable(InternalWidgets.concatWidgets(Widgets.createButton(area, NarratorChatListener.f_93310_).focusable(false).onClick(button -> {
                ConfigManager.getInstance().toggleCraftableOnly();
                ENTRY_LIST_WIDGET.updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            }).onRender((matrices, button) -> button.setTint(ConfigManager.getInstance().isCraftableOnlyEnabled() ? 939579655 : 956235776)).containsMousePredicate((button, point) -> button.getBounds().contains(point) && this.isNotInExclusionZones(point.x, point.y)).tooltipLineSupplier(button -> new TranslatableComponent(ConfigManager.getInstance().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all")), Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
                Vector4f vector = new Vector4f((float)(area.x + 2), (float)(area.y + 2), (float)(helper.m_93252_() - 10), 1.0f);
                vector.m_123607_(matrices.m_85850_().m_85861_());
                itemRenderer.f_115093_ = vector.m_123616_();
                itemRenderer.m_115123_(icon, (int)vector.m_123601_(), (int)vector.m_123615_());
                itemRenderer.f_115093_ = 0.0f;
            }))), 0.0, 0.0, 600.0));
        }
        this.widgets.add(this.draggingStack);
    }

    private Rectangle getSubsetsButtonBounds() {
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            ScreenRegistry registry = ScreenRegistry.getInstance();
            Rectangle screenBounds = registry.getScreenBounds(this.minecraft.f_91080_);
            return new Rectangle(screenBounds.x, 3, screenBounds.width, 18);
        }
        return null;
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world.m_46470_()) {
            return Weather.THUNDER;
        }
        if (world.m_6106_().m_6533_()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(GameType gameMode) {
        return I18n.m_118938_((String)("text.rei.short_gamemode." + gameMode.m_46405_()), (Object[])new Object[0]);
    }

    private String getGameModeText(GameType gameMode) {
        return I18n.m_118938_((String)("selectWorld.gameMode." + gameMode.m_46405_()), (Object[])new Object[0]);
    }

    private GameType getCurrentGameMode() {
        PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(Minecraft.m_91087_().f_91074_.m_36316_().getId());
        return info == null ? GameType.SURVIVAL : info.m_105325_();
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1;
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            widthRemoved += 22;
        }
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            widthRemoved += 22;
        }
        SearchFieldLocation searchFieldLocation = REIRuntime.getInstance().getContextualSearchFieldLocation();
        switch (searchFieldLocation) {
            case TOP_SIDE: {
                return this.getTopSideSearchFieldArea(widthRemoved);
            }
            case BOTTOM_SIDE: {
                return this.getBottomSideSearchFieldArea(widthRemoved);
            }
        }
        return this.getCenterSearchFieldArea(widthRemoved);
    }

    private Rectangle getTopSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getBottomSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, this.window.m_85446_() - 22, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getCenterSearchFieldArea(int widthRemoved) {
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(this.minecraft.f_91080_);
        return this.getBottomCenterSearchFieldArea(screenBounds, widthRemoved);
    }

    private Rectangle getBottomCenterSearchFieldArea(Rectangle containerBounds, int widthRemoved) {
        return new Rectangle(containerBounds.x, this.window.m_85446_() - 22, containerBounds.width - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle area = this.getSearchFieldArea();
        area.setLocation(area.x + area.width + 4, area.y - 1);
        area.setSize(20, 20);
        return area;
    }

    private Rectangle getConfigButtonArea() {
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            Rectangle area = this.getSearchFieldArea();
            area.setLocation(area.x + area.width + (ConfigObject.getInstance().isCraftableFilterEnabled() ? 26 : 4), area.y - 1);
            area.setSize(20, 20);
            return area;
        }
        return new Rectangle(ConfigObject.getInstance().isLeftHandSidePanel() ? this.window.m_85445_() - 30 : 10, 10, 20, 20);
    }

    private String getCheatModeText() {
        return I18n.m_118938_((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, final int mouseX, final int mouseY, float delta) {
        if (this.shouldReload) {
            ENTRY_LIST_WIDGET.updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
            this.init();
        } else {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(this.minecraft.f_91080_)) {
                if (decider == null || !decider.shouldRecalculateArea(ConfigObject.getInstance().getDisplayPanelLocation(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (ConfigManager.getInstance().isCraftableOnlyEnabled() && CraftableFilter.INSTANCE.wasDirty()) {
            ENTRY_LIST_WIDGET.updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isHighlighting) {
            OverlayDecider decider;
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 200.0);
            decider = Minecraft.m_91087_().f_91080_;
            if (decider instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)decider;
                int x = containerScreen.f_97735_;
                int y = containerScreen.f_97736_;
                for (Slot slot : containerScreen.m_6262_().f_38839_) {
                    if (slot.m_6657_() && ENTRY_LIST_WIDGET.matches(EntryStacks.of(slot.m_7993_()))) continue;
                    this.m_93179_(matrices, x + slot.f_40220_, y + slot.f_40221_, x + slot.f_40220_ + 16, y + slot.f_40221_ + 16, -601874400, -601874400);
                }
            }
            matrices.m_85849_();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderWidgets(matrices, mouseX, mouseY, delta);
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            final Screen screen = Minecraft.m_91087_().f_91080_;
            ClickArea.ClickAreaContext<Screen> context = new ClickArea.ClickAreaContext<Screen>(){

                @Override
                public Screen getScreen() {
                    return screen;
                }

                @Override
                public Point getMousePosition() {
                    return new Point(mouseX, mouseY);
                }
            };
            Set<CategoryIdentifier<?>> categories = ScreenRegistry.getInstance().handleClickArea(screen.getClass(), context);
            if (categories != null && !categories.isEmpty()) {
                Component collect = CollectionUtils.mapAndJoinToComponent(categories, identifier -> CategoryRegistry.getInstance().tryGet(identifier).map(config -> config.getCategory().getTitle()).orElse((Component)new ImmutableTextComponent(identifier.toString())), (Component)new ImmutableTextComponent(", "));
                Tooltip.create(new Component[]{new TranslatableComponent("text.rei.view_recipes_for", new Object[]{collect})}).queue();
            }
        }
    }

    public void lateRender(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Screen currentScreen;
        if (REIRuntime.getInstance().isOverlayVisible()) {
            REIRuntimeImpl.getSearchField().laterRender(matrices, mouseX, mouseY, delta);
            for (Widget widget : this.widgets) {
                if (!(widget instanceof LateRenderable) || this.overlayMenu != null && this.overlayMenu.wrappedMenu == widget) continue;
                widget.m_6305_(matrices, mouseX, mouseY, delta);
            }
            if (this.overlayMenu != null) {
                if (!this.overlayMenu.inBounds.test(PointHelper.ofMouse())) {
                    this.closeOverlayMenu();
                } else {
                    if (this.overlayMenu.wrappedMenu.containsMouse(mouseX, mouseY)) {
                        TOOLTIPS.clear();
                    }
                    this.overlayMenu.wrappedMenu.m_6305_(matrices, mouseX, mouseY, delta);
                }
            }
        }
        if (!((currentScreen = Minecraft.m_91087_().f_91080_) instanceof DefaultDisplayViewingScreen) || !((DefaultDisplayViewingScreen)currentScreen).choosePageActivated) {
            for (Tooltip tooltip : TOOLTIPS) {
                if (tooltip == null) continue;
                this.renderTooltip(matrices, tooltip);
            }
        }
        TOOLTIPS.clear();
        if (REIRuntime.getInstance().isOverlayVisible()) {
            for (Runnable runnable : AFTER_RENDER) {
                runnable.run();
            }
            AFTER_RENDER.clear();
        }
    }

    public void renderTooltip(PoseStack matrices, Tooltip tooltip) {
        ScreenOverlayImpl.renderTooltipInner(this.minecraft.f_91080_, matrices, tooltip, tooltip.getX(), tooltip.getY());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderTooltipInner(Screen screen, PoseStack matrices, Tooltip tooltip, int mouseX, int mouseY) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ScreenOverlayImplImpl.renderTooltipInner(screen, (PoseStack)var1_1, (Tooltip)var2_2, (int)var3_3, (int)var4_4);
    }

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void renderWidgets(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.leftButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
            this.rightButton.setEnabled(ENTRY_LIST_WIDGET.getTotalPages() > 1);
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (this.overlayMenu != null && this.overlayMenu.wrappedMenu.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isInside(PointHelper.ofMouse())) {
            if (ENTRY_LIST_WIDGET.m_6050_(mouseX, mouseY, amount)) {
                return true;
            }
            if (!Screen.m_96637_() && !ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                if (amount > 0.0 && this.leftButton.isEnabled()) {
                    this.leftButton.onClick();
                } else if (amount < 0.0 && this.rightButton.isEnabled()) {
                    this.rightButton.onClick();
                } else {
                    return false;
                }
                return true;
            }
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ENTRY_LIST_WIDGET || favoritesListWidget != null && widget == favoritesListWidget || this.overlayMenu != null && widget == this.overlayMenu.wrappedMenu || !widget.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (REIRuntime.getInstance().isOverlayVisible()) {
            if (REIRuntimeImpl.getSearchField().m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (GuiEventListener guiEventListener : this.widgets) {
                if (guiEventListener == REIRuntimeImpl.getSearchField() || !guiEventListener.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return true;
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.m_91087_().f_91080_, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                ConfigManager.getInstance().saveConfig();
                FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
                if (favoritesListWidget != null) {
                    favoritesListWidget.updateSearch();
                }
                return true;
            }
        }
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.m_7522_((GuiEventListener)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = System.currentTimeMillis();
            REIRuntimeImpl.getSearchField().keybindFocusKey = keyCode;
            return true;
        }
        return false;
    }

    public boolean m_5534_(char char_1, int int_1) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (REIRuntimeImpl.getSearchField().m_5534_(char_1, int_1)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.widgets) {
            if (guiEventListener == REIRuntimeImpl.getSearchField() || !guiEventListener.m_5534_(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> m_6702_() {
        return this.widgets;
    }

    public boolean m_6375_(final double mouseX, final double mouseY, int button) {
        boolean visible = REIRuntime.getInstance().isOverlayVisible();
        if (visible && this.configButton.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.configButton);
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesMouse(button)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return REIRuntime.getInstance().isOverlayVisible();
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.m_91087_().f_91080_, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (visible && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                ConfigManager.getInstance().saveConfig();
                FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
                if (favoritesListWidget != null) {
                    favoritesListWidget.updateSearch();
                }
                return true;
            }
        }
        if (visible && this.overlayMenu != null && this.overlayMenu.wrappedMenu.m_6375_(mouseX, mouseY, button)) {
            if (this.overlayMenu != null) {
                this.m_7522_((GuiEventListener)this.overlayMenu.wrappedMenu);
            } else {
                this.m_7522_(null);
            }
            if (button == 0) {
                this.m_7897_(true);
            }
            REIRuntimeImpl.getSearchField().setFocused(false);
            return true;
        }
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            final Screen screen = Minecraft.m_91087_().f_91080_;
            ClickArea.ClickAreaContext<Screen> clickAreaContext = new ClickArea.ClickAreaContext<Screen>(){

                @Override
                public Screen getScreen() {
                    return screen;
                }

                @Override
                public Point getMousePosition() {
                    return new Point(mouseX, mouseY);
                }
            };
            Set<CategoryIdentifier<?>> categories = ScreenRegistry.getInstance().handleClickArea(screen.getClass(), clickAreaContext);
            if (categories != null && !categories.isEmpty()) {
                ViewSearchBuilder.builder().addCategories(categories).open();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
        }
        if (!visible) {
            return false;
        }
        for (GuiEventListener guiEventListener : this.widgets) {
            if (guiEventListener == this.configButton || this.overlayMenu != null && guiEventListener == this.overlayMenu.wrappedMenu || !guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(guiEventListener);
            if (button == 0) {
                this.m_7897_(true);
            }
            if (!(guiEventListener instanceof OverlaySearchField)) {
                REIRuntimeImpl.getSearchField().setFocused(false);
            }
            return true;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesMouse(button)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.m_7522_((GuiEventListener)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = -1L;
            REIRuntimeImpl.getSearchField().keybindFocusKey = -1;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        return this.m_7222_() != null && this.m_7282_() && int_1 == 0 && this.m_7222_().m_7979_(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    @Override
    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(Minecraft.m_91087_().f_91080_)) {
            InteractionResult in = decider.isInZone(mouseX, mouseY);
            if (in == InteractionResult.PASS) continue;
            return in == InteractionResult.SUCCESS;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }

    @Override
    public OverlayListWidget getEntryList() {
        return ENTRY_LIST_WIDGET;
    }

    @Override
    public Optional<OverlayListWidget> getFavoritesList() {
        return Optional.ofNullable(ScreenOverlayImpl.getFavoritesListWidget());
    }

    private static class OverlayMenu {
        private UUID uuid;
        private Menu menu;
        private Widget wrappedMenu;
        private Predicate<Point> inBounds;

        public OverlayMenu(UUID uuid, Menu menu, Widget wrappedMenu, Predicate<Point> or, Predicate<Point> and) {
            this.uuid = uuid;
            this.menu = menu;
            this.wrappedMenu = wrappedMenu;
            this.inBounds = or.or(point -> menu.getBounds().contains(point)).and(and);
        }
    }
}

