/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.craftable;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public class CraftableFilter {
    public static final CraftableFilter INSTANCE = new CraftableFilter();
    private boolean dirty = false;
    private LongSet invStacks = new LongOpenHashSet();

    public void markDirty() {
        this.dirty = true;
    }

    public boolean wasDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return Minecraft.m_91087_().f_91074_.f_36096_ != null;
    }

    public void tick() {
        LongSet currentStacks;
        if (this.dirty) {
            return;
        }
        try {
            currentStacks = ClientHelperImpl.getInstance()._getInventoryItemsTypes();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            currentStacks = LongSets.EMPTY_SET;
        }
        if (!currentStacks.equals(this.invStacks)) {
            this.invStacks = new LongOpenHashSet((LongCollection)currentStacks);
            this.markDirty();
        }
    }

    public boolean matches(EntryStack<?> stack, Iterable<SlotAccessor> inputSlots) {
        if (this.invStacks.contains(EntryStacks.hashFuzzy(stack))) {
            return true;
        }
        if (stack.getType() != VanillaEntryTypes.ITEM) {
            return false;
        }
        for (SlotAccessor slot : inputSlots) {
            EntryStack<ItemStack> itemStack = EntryStacks.of(slot.getItemStack());
            if (itemStack.isEmpty() || !EntryStacks.equalsFuzzy(itemStack, stack)) continue;
            return true;
        }
        return false;
    }
}

