/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.dragging;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.util.Animator;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CurrentDraggingStack
extends Widget
implements LateRenderable,
DraggingContext<Screen> {
    private DraggableStackProvider<Screen> provider;
    private DraggableStackVisitor<Screen> visitor;
    @Nullable
    private DraggableEntry entry;
    private final List<RenderBackEntry> backToOriginals = new ArrayList<RenderBackEntry>();
    private final Set<ShapeBounds> bounds = new HashSet<ShapeBounds>();

    public void set(DraggableStackProvider<Screen> provider, DraggableStackVisitor<Screen> visitor) {
        this.provider = provider;
        this.visitor = visitor;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Integer hash = null;
        if (this.entry != null) {
            if (!this.entry.dragging) {
                double requiredDistance;
                double yDistance;
                Point startPoint = this.entry.start;
                double xDistance = Math.abs(startPoint.x - mouseX);
                if (xDistance * xDistance + (yDistance = (double)Math.abs(startPoint.y - mouseY)) * yDistance > (requiredDistance = 8.0) * requiredDistance) {
                    this.entry.dragging = true;
                    this.entry.stack.drag();
                }
            }
            if (!RoughlyEnoughItemsCoreClient.isLeftMousePressed) {
                this.drop();
            } else if (this.entry.dragging) {
                matrices.m_85836_();
                matrices.m_85837_(0.0, 0.0, 600.0);
                this.entry.stack.render(matrices, new Rectangle(mouseX - 8, mouseY - 8, 16, 16), mouseX, mouseY, delta);
                matrices.m_85849_();
                VoxelShape shape = this.entry.getBoundsProvider().bounds();
                ShapeBounds shapeBounds = new ShapeBounds(shape);
                shapeBounds.alpha.setTo(60.0, 300L);
                this.bounds.add(shapeBounds);
                hash = shapeBounds.hash;
            }
        }
        for (ShapeBounds bound : this.bounds) {
            if (hash != null && hash == bound.hash || bound.alpha.target() == 0.0) continue;
            bound.alpha.setTo(0.0, 300L);
        }
        Iterator<Object> iterator = this.bounds.iterator();
        while (iterator.hasNext()) {
            ShapeBounds bounds = iterator.next();
            bounds.update(delta);
            if (bounds.alpha.target() == 0.0 && bounds.alpha.doubleValue() <= 2.0) {
                iterator.remove();
                continue;
            }
            bounds.shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                matrices.m_85836_();
                matrices.m_85837_(0.0, 0.0, 500.0);
                this.m_93179_(matrices, (int)x1, (int)y1, (int)x2, (int)y2, 0xFDFF6B | bounds.alpha.intValue() << 24, 0xFDFF6B | bounds.alpha.intValue() << 24);
                matrices.m_85849_();
            });
        }
        iterator = this.backToOriginals.iterator();
        while (iterator.hasNext()) {
            RenderBackEntry renderBackEntry = (RenderBackEntry)iterator.next();
            renderBackEntry.update(delta);
            if (Math.abs(renderBackEntry.x.doubleValue() - renderBackEntry.x.target()) <= 2.0 && Math.abs(renderBackEntry.y.doubleValue() - renderBackEntry.y.target()) <= 2.0) {
                iterator.remove();
                continue;
            }
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 600.0);
            renderBackEntry.stack.render(matrices, new Rectangle(renderBackEntry.x.intValue(), renderBackEntry.y.intValue(), 16, 16), mouseX, mouseY, delta);
            matrices.m_85849_();
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.drop();
        DraggableStack hoveredStack = this.provider.getHoveredStack(this, mouseX, mouseY);
        if (hoveredStack != null) {
            this.entry = new DraggableEntry(hoveredStack, new Point(mouseX, mouseY));
        }
        return false;
    }

    public boolean m_6348_(double d, double e, int i) {
        return false;
    }

    public boolean m_7979_(double mouseX1, double mouseY1, int button, double mouseX2, double mouseY2) {
        return this.entry != null && this.entry.dragging;
    }

    private boolean drop() {
        if (this.entry != null && this.entry.dragging) {
            boolean released = this.visitor.acceptDraggedStack(this, this.entry.stack);
            this.entry.stack.release(released);
            this.entry = null;
            return true;
        }
        this.entry = null;
        return false;
    }

    @Override
    public Screen getScreen() {
        return Minecraft.m_91087_().f_91080_;
    }

    @Override
    @Nullable
    public DraggableStack getCurrentStack() {
        return this.entry != null && this.entry.dragging ? this.entry.stack : null;
    }

    @Override
    @Nullable
    public Point getCurrentPosition() {
        return this.isDraggingStack() ? PointHelper.ofMouse() : null;
    }

    @Override
    public void renderBackToPosition(DraggableStack stack, Point initialPosition, Supplier<Point> position) {
        this.backToOriginals.add(new RenderBackEntry(stack, initialPosition, position));
    }

    private class DraggableEntry {
        private final DraggableStack stack;
        private final Point start;
        private boolean dragging = false;
        private DraggableStackVisitor.BoundsProvider boundsProvider;

        private DraggableEntry(DraggableStack stack, Point start) {
            this.stack = stack;
            this.start = start;
        }

        public DraggableStackVisitor.BoundsProvider getBoundsProvider() {
            if (this.boundsProvider == null) {
                this.boundsProvider = DraggableStackVisitor.BoundsProvider.concat(CurrentDraggingStack.this.visitor.getDraggableAcceptingBounds(CurrentDraggingStack.this, this.stack).toList());
            }
            return this.boundsProvider;
        }
    }

    private static class ShapeBounds {
        private VoxelShape shape;
        private Animator alpha;
        private int hash;

        public ShapeBounds(VoxelShape shape) {
            this.shape = shape;
            this.alpha = new Animator(0.0);
            this.hash = shape.m_83299_().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = o;
            if (!(object instanceof ShapeBounds)) {
                return false;
            }
            ShapeBounds shapeBounds = (ShapeBounds)object;
            return this.hash == shapeBounds.hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public void update(double delta) {
            this.alpha.update(delta);
        }
    }

    private static class RenderBackEntry {
        private final DraggableStack stack;
        private final Supplier<Point> position;
        private Animator x = new Animator();
        private Animator y = new Animator();
        private int lastDestination = -1;

        public RenderBackEntry(DraggableStack stack, Point initialPosition, Supplier<Point> position) {
            this.stack = stack;
            this.x.setAs(initialPosition.x - 8);
            this.y.setAs(initialPosition.y - 8);
            this.position = position;
        }

        public Point getPosition() {
            return this.position.get();
        }

        public void update(double delta) {
            this.x.update(delta);
            this.y.update(delta);
            Point position = this.getPosition();
            if (this.lastDestination != position.hashCode()) {
                this.lastDestination = position.hashCode();
                this.x.setTo(position.x, 200L);
                this.y.setTo(position.y, 200L);
            }
        }
    }
}

