/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.subsets.SubsetsRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class Menu
extends WidgetWithBounds
implements LateRenderable {
    public static final UUID SUBSETS = UUID.randomUUID();
    public static final UUID WEATHER = UUID.randomUUID();
    public static final UUID GAME_TYPE = UUID.randomUUID();
    public final Point menuStartPoint;
    private final List<MenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            int i = 0;
            for (MenuEntry entry : Menu.this.m_6702_()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        public Rectangle getBounds() {
            return Menu.this.getInnerBounds();
        }

        public boolean hasScrollBar() {
            return Menu.this.hasScrollBar();
        }
    };

    public Menu(Point menuStartPoint, Collection<MenuEntry> entries) {
        this.menuStartPoint = menuStartPoint;
        this.buildEntries(entries);
    }

    public static Menu createSubsetsMenuFromRegistry(Point menuStartPoint) {
        EntryRegistry instance = EntryRegistry.getInstance();
        List stacks = instance.getEntryStacks().collect(Collectors.toList());
        HashMap entries = Maps.newHashMap();
        Map<String, Object> allEntries = Menu.getOrCreateSubEntryInMap(entries, "roughlyenoughitems:all_entries");
        for (EntryStack stack : stacks) {
            Menu.putEntryInMap(allEntries, stack);
        }
        Map<String, Object> itemGroups = Menu.getOrCreateSubEntryInMap(entries, "roughlyenoughitems:item_groups");
        for (Item item : Registry.f_122827_) {
            CreativeModeTab group = item.m_41471_();
            if (group == null) continue;
            try {
                List<ItemStack> list = instance.appendStacksForItem(item);
                Map<String, Object> groupMenu = Menu.getOrCreateSubEntryInMap(itemGroups, "_item_group_" + group.f_40763_);
                for (ItemStack stack : list) {
                    Menu.putEntryInMap(groupMenu, EntryStacks.of(stack));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Set<String> paths = SubsetsRegistry.getInstance().getPaths();
        for (String path : paths) {
            Map<Object, Object> lastMap = entries;
            String[] pathSegments = path.split("/");
            for (String pathSegment : pathSegments) {
                lastMap = Menu.getOrCreateSubEntryInMap(lastMap, pathSegment);
            }
            for (EntryStack entryStack : SubsetsRegistry.getInstance().getPathEntries(path)) {
                EntryStack<?> firstStack = CollectionUtils.findFirstOrNullEqualsExact(stacks, entryStack);
                if (firstStack == null) continue;
                Menu.putEntryInMap((Map<String, Object>)lastMap, firstStack);
            }
        }
        return new Menu(menuStartPoint, Menu.buildEntries(entries));
    }

    private static Map<String, Object> getOrCreateSubEntryInMap(Map<String, Object> parent, String pathSegment) {
        Menu.putEntryInMap(parent, pathSegment);
        return (Map)parent.get(pathSegment);
    }

    private static void putEntryInMap(Map<String, Object> parent, String pathSegment) {
        if (!parent.containsKey(pathSegment)) {
            parent.put(pathSegment, Maps.newHashMap());
        }
    }

    private static void putEntryInMap(Map<String, Object> parent, EntryStack<?> stack) {
        Set items = (Set)parent.get("items");
        if (items == null) {
            items = Sets.newLinkedHashSet();
            parent.put("items", items);
        }
        items.add(stack);
    }

    private static List<MenuEntry> buildEntries(Map<String, Object> map) {
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals("items")) {
                Set items = (Set)entry.getValue();
                for (EntryStack item : items) {
                    entries.add(new EntryStackSubsetsMenuEntry(item));
                }
                continue;
            }
            Map entryMap = (Map)entry.getValue();
            if (entry.getKey().startsWith("_item_group_")) {
                entries.add(new SubSubsetsMenuEntry(I18n.m_118938_((String)entry.getKey().replace("_item_group_", "itemGroup."), (Object[])new Object[0]), Menu.buildEntries(entryMap)));
                continue;
            }
            String translationKey = "subsets.rei." + entry.getKey().replace(':', '.');
            if (!I18n.m_118936_((String)translationKey)) {
                RoughlyEnoughItemsCore.LOGGER.warn("Subsets menu " + translationKey + " does not have a translation");
            }
            entries.add(new SubSubsetsMenuEntry(I18n.m_118938_((String)translationKey, (Object[])new Object[0]), Menu.buildEntries(entryMap)));
        }
        return entries;
    }

    private void buildEntries(Collection<MenuEntry> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        this.entries.sort(Comparator.comparing(entry -> entry instanceof SubSubsetsMenuEntry ? 0 : 1).thenComparing(entry -> {
            String string;
            Object menuEntry$temp = entry;
            if (menuEntry$temp instanceof SubSubsetsMenuEntry) {
                SubSubsetsMenuEntry menuEntry = (SubSubsetsMenuEntry)menuEntry$temp;
                string = menuEntry.text;
            } else {
                string = "";
            }
            return string;
        }));
        for (MenuEntry entry2 : this.entries) {
            entry2.parent = this;
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight() + 2);
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.menuStartPoint.x + 1, this.menuStartPoint.y + 1, this.getMaxEntryWidth() + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight());
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight();
    }

    public int getInnerHeight() {
        return Math.min(this.scrolling.getMaxScrollHeight(), this.minecraft.f_91080_.f_96544_ - 20 - this.menuStartPoint.y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (MenuEntry entry : this.m_6702_()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        MenuEntry menuEntry;
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        Menu.m_93172_((PoseStack)matrices, (int)bounds.x, (int)bounds.y, (int)bounds.getMaxX(), (int)bounds.getMaxY(), (int)(this.containsMouse(mouseX, mouseY) ? (REIRuntime.getInstance().isDarkThemeEnabled() ? -17587 : -1) : -6250336));
        Menu.m_93172_((PoseStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)-16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        GuiEventListener guiEventListener = this.m_7222_();
        MenuEntry focused = guiEventListener instanceof MenuEntry ? (menuEntry = (MenuEntry)guiEventListener) : null;
        int currentY = (int)((double)innerBounds.y - this.scrolling.scrollAmount);
        for (MenuEntry child : this.m_6702_()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = (int)((double)innerBounds.y - this.scrolling.scrollAmount);
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getScissorBounds());
        for (MenuEntry child : this.m_6702_()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.m_6305_(matrices, mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.m_7522_((GuiEventListener)focused);
        this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.scrolling.updatePosition(delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button) || this.getInnerBounds().contains(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        for (MenuEntry child : this.m_6702_()) {
            if (!(child instanceof SubSubsetsMenuEntry) || !child.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public List<MenuEntry> m_6702_() {
        return this.entries;
    }
}

