/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubSubsetsMenuEntry;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class EntryStackSubsetsMenuEntry
extends MenuEntry {
    final EntryStack stack;
    private int x;
    private int y;
    private int width;
    private boolean selected;
    private boolean containsMouse;
    private boolean rendering;
    private boolean clickedLast = false;
    private Boolean isFiltered = null;

    public EntryStackSubsetsMenuEntry(EntryStack stack) {
        this.stack = stack;
    }

    @Override
    public int getEntryWidth() {
        return 18;
    }

    @Override
    public int getEntryHeight() {
        return 18;
    }

    @Override
    public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
        this.x = xPos;
        this.y = yPos;
        this.selected = selected;
        this.containsMouse = containsMouse;
        this.rendering = rendering;
        this.width = width;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.isFiltered()) {
            if (this.selected) {
                EntryStackSubsetsMenuEntry.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 18), (int)-26215);
            } else {
                EntryStackSubsetsMenuEntry.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 18), (int)-65536);
            }
        } else if (this.selected) {
            EntryStackSubsetsMenuEntry.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 18), (int)0x45FFFFFF);
        }
        if (this.containsMouse && mouseX >= this.x + this.width / 2 - 8 && mouseX <= this.x + this.width / 2 + 8 && mouseY >= this.y + 1 && mouseY <= this.y + 17) {
            REIRuntime.getInstance().queueTooltip(this.stack.getTooltip(new Point(mouseX, mouseY)));
            if (RoughlyEnoughItemsCoreClient.isLeftMousePressed && !this.clickedLast) {
                this.clickedLast = true;
                if (!this.getParent().scrolling.draggingScrollBar) {
                    this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    List<EntryStack<?>> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
                    if (this.isFiltered()) {
                        filteredStacks.removeIf(next -> EntryStacks.equalsExact(next, this.stack));
                    } else {
                        filteredStacks.add(this.stack.normalize());
                    }
                    Menu menu = ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).getOverlayMenu();
                    if (menu != null) {
                        this.recalculateFilter(menu);
                    }
                    ConfigManager.getInstance().saveConfig();
                    EntryRegistry.getInstance().refilter();
                    if (REIRuntimeImpl.getSearchField() != null) {
                        ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
                    }
                }
            } else if (!RoughlyEnoughItemsCoreClient.isLeftMousePressed) {
                this.clickedLast = false;
            }
        } else {
            this.clickedLast = false;
        }
        this.stack.render(matrices, new Rectangle(this.x + this.width / 2 - 8, this.y + 1, 16, 16), mouseX, mouseY, delta);
    }

    void recalculateFilter(Menu menu) {
        for (MenuEntry child : menu.m_6702_()) {
            if (child instanceof SubSubsetsMenuEntry && ((SubSubsetsMenuEntry)child).getSubsetsMenu() != null) {
                this.recalculateFilter(((SubSubsetsMenuEntry)child).getSubsetsMenu());
                continue;
            }
            if (!(child instanceof EntryStackSubsetsMenuEntry) || !EntryStacks.equalsExact(((EntryStackSubsetsMenuEntry)child).stack, this.stack)) continue;
            ((EntryStackSubsetsMenuEntry)child).isFiltered = null;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 18);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    public boolean isFiltered() {
        if (this.isFiltered == null) {
            List<EntryStack<?>> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
            this.isFiltered = CollectionUtils.findFirstOrNullEqualsExact(filteredStacks, this.stack) != null;
        }
        return this.isFiltered;
    }
}

