/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.EntryStackSubsetsMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@ApiStatus.Internal
public class SubSubsetsMenuEntry
extends MenuEntry {
    public final String text;
    private int textWidth = -69;
    private int x;
    private int y;
    private int width;
    private boolean selected;
    private boolean containsMouse;
    private boolean rendering;
    private List<MenuEntry> entries;
    private Menu subsetsMenu;
    private Tuple<Integer, Integer> filteredRatio = null;
    private long lastListHash = -1L;
    private boolean clickedBefore = false;

    public SubSubsetsMenuEntry(String text) {
        this(text, Collections.emptyList());
    }

    public SubSubsetsMenuEntry(String text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubSubsetsMenuEntry(String text, List<MenuEntry> entries) {
        this.text = text;
        this.entries = entries;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.m_92895_(this.text));
        }
        return this.textWidth;
    }

    public Menu getSubsetsMenu() {
        if (this.subsetsMenu == null) {
            this.subsetsMenu = new Menu(new Point(this.getParent().getBounds().getMaxX() - 1, this.y - 1), this.entries);
        }
        return this.subsetsMenu;
    }

    @Override
    public int getEntryWidth() {
        return 12 + this.getTextWidth() + 4;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    @Override
    public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
        this.x = xPos;
        this.y = yPos;
        this.selected = selected;
        this.containsMouse = containsMouse;
        this.rendering = rendering;
        this.width = width;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        double filteredRatio = this.getFilteredRatio();
        if (filteredRatio > 0.0) {
            filteredRatio = filteredRatio * 0.85 + 0.15;
            SubSubsetsMenuEntry.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)((0xFF0000 | Mth.m_14165_((double)(filteredRatio * 255.0)) << 24) + (this.selected ? 39321 : 0)));
        } else if (this.selected) {
            SubSubsetsMenuEntry.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
        }
        if (this.selected) {
            if (!this.entries.isEmpty()) {
                Menu menu = this.getSubsetsMenu();
                menu.menuStartPoint.x = this.getParent().getBounds().getMaxX() - 1;
                menu.menuStartPoint.y = this.y - 1;
                ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
                ScissorsHandler.INSTANCE.clearScissors();
                menu.m_6305_(matrices, mouseX, mouseY, delta);
                for (Rectangle area : areas) {
                    ScissorsHandler.INSTANCE.scissor(area);
                }
            } else {
                this.clickedBefore = false;
            }
            if (this.clickedBefore) {
                if (this.rendering && mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + 12 && !this.entries.isEmpty()) {
                    REIRuntime.getInstance().queueTooltip(Tooltip.create(new Component[]{new TextComponent("Click again to filter everything in this group.")}));
                } else {
                    this.clickedBefore = false;
                }
            }
        } else {
            this.clickedBefore = false;
        }
        this.font.m_92883_(matrices, this.text, (float)(this.x + 2), (float)(this.y + 2), this.selected ? 0xFFFFFF : 0x888888);
        if (!this.entries.isEmpty()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TabWidget.CHEST_GUI_TEXTURE);
            this.m_93228_(matrices, this.x + this.width - 15, this.y - 2, 0, 28, 18, 18);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12) && !this.entries.isEmpty()) {
            if (this.clickedBefore) {
                this.clickedBefore = false;
                List<EntryStack<?>> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
                Menu overlay = ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).getOverlayMenu();
                this.setFiltered(filteredStacks, overlay, this, !(this.getFilteredRatio() > 0.0));
                ConfigManager.getInstance().saveConfig();
                EntryRegistry.getInstance().refilter();
                if (REIRuntimeImpl.getSearchField() != null) {
                    ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
                }
            } else {
                this.clickedBefore = true;
            }
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void setFiltered(List<EntryStack<?>> filteredStacks, Menu subsetsMenu, SubSubsetsMenuEntry subSubsetsMenuEntry, boolean filtered) {
        for (MenuEntry entry : subSubsetsMenuEntry.entries) {
            MenuEntry menuEntry = entry;
            if (menuEntry instanceof EntryStackSubsetsMenuEntry) {
                EntryStackSubsetsMenuEntry menuEntry2 = (EntryStackSubsetsMenuEntry)menuEntry;
                if (menuEntry2.isFiltered() != filtered) {
                    if (!filtered) {
                        filteredStacks.removeIf(next -> EntryStacks.equalsExact(next, menuEntry.stack));
                    } else {
                        filteredStacks.add(menuEntry2.stack.normalize());
                    }
                }
                if (subsetsMenu == null) continue;
                menuEntry2.recalculateFilter(subsetsMenu);
                continue;
            }
            menuEntry = entry;
            if (!(menuEntry instanceof SubSubsetsMenuEntry)) continue;
            SubSubsetsMenuEntry menuEntry3 = (SubSubsetsMenuEntry)menuEntry;
            this.setFiltered(filteredStacks, subsetsMenu, menuEntry3, filtered);
        }
    }

    public double getFilteredRatio() {
        Tuple<Integer, Integer> pair = this.getFilteredRatioPair();
        return (Integer)pair.m_14419_() == 0 ? 0.0 : (double)((Integer)pair.m_14418_()).intValue() / (double)((Integer)pair.m_14419_()).intValue();
    }

    public Tuple<Integer, Integer> getFilteredRatioPair() {
        List<EntryStack<?>> filteredStacks = ConfigObject.getInstance().getFilteredStacks();
        if (this.lastListHash != (long)filteredStacks.hashCode()) {
            int size = 0;
            int filtered = 0;
            for (MenuEntry entry : this.entries) {
                if (entry instanceof EntryStackSubsetsMenuEntry) {
                    ++size;
                    if (!((EntryStackSubsetsMenuEntry)entry).isFiltered()) continue;
                    ++filtered;
                    continue;
                }
                if (!(entry instanceof SubSubsetsMenuEntry)) continue;
                Tuple<Integer, Integer> pair = ((SubSubsetsMenuEntry)entry).getFilteredRatioPair();
                filtered += ((Integer)pair.m_14418_()).intValue();
                size += ((Integer)pair.m_14419_()).intValue();
            }
            this.filteredRatio = new Tuple((Object)filtered, (Object)size);
            this.lastListHash = filteredStacks.hashCode();
        }
        return this.filteredRatio;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        if (this.subsetsMenu != null && !this.subsetsMenu.m_6702_().isEmpty() && this.selected) {
            return this.subsetsMenu.containsMouse(mouseX, mouseY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.subsetsMenu != null && !this.subsetsMenu.m_6702_().isEmpty() && this.selected && this.subsetsMenu.m_6050_(mouseX, mouseY, amount);
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (this.subsetsMenu != null && !this.subsetsMenu.m_6702_().isEmpty() && this.selected) {
            return Collections.singletonList(this.subsetsMenu);
        }
        return Collections.emptyList();
    }
}

