/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDisplayViewingScreen
extends Screen
implements DisplayScreen {
    protected final Map<DisplayCategory<?>, List<Display>> categoryMap;
    protected final List<DisplayCategory<?>> categories;
    protected List<EntryStack<?>> ingredientStackToNotice = new ArrayList();
    protected List<EntryStack<?>> resultStackToNotice = new ArrayList();
    protected int selectedCategoryIndex = 0;
    protected int tabsPerPage;
    protected Rectangle bounds;

    protected AbstractDisplayViewingScreen(Map<DisplayCategory<?>, List<Display>> categoryMap, @Nullable CategoryIdentifier<?> category, int tabsPerPage) {
        super(NarratorChatListener.f_93310_);
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        this.tabsPerPage = tabsPerPage;
        if (category != null) {
            for (int i = 0; i < this.categories.size(); ++i) {
                if (!this.categories.get(i).getCategoryIdentifier().equals(category)) continue;
                this.selectedCategoryIndex = i;
                break;
            }
        }
    }

    public List<GuiEventListener> _children() {
        return this.m_6702_();
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void addIngredientToNotice(EntryStack<?> stack) {
        this.ingredientStackToNotice.add(stack);
    }

    @Override
    public void addResultToNotice(EntryStack<?> stack) {
        this.resultStackToNotice.add(stack);
    }

    @Override
    public List<EntryStack<?>> getIngredientsToNotice() {
        return Collections.unmodifiableList(this.ingredientStackToNotice);
    }

    @Override
    public List<EntryStack<?>> getResultsToNotice() {
        return Collections.unmodifiableList(this.resultStackToNotice);
    }

    @Override
    public DisplayCategory<Display> getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex);
    }

    @Override
    public void previousCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (--currentCategoryIndex < 0) {
            currentCategoryIndex = this.categories.size() - 1;
        }
        ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, this.categories.get(currentCategoryIndex).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
    }

    @Override
    public void nextCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (++currentCategoryIndex >= this.categories.size()) {
            currentCategoryIndex = 0;
        }
        ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, this.categories.get(currentCategoryIndex).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
    }

    protected void transformIngredientNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(1, setupDisplay, noticeStacks);
    }

    protected void transformResultNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(2, setupDisplay, noticeStacks);
    }

    private static void transformNotice(int marker, List<? extends GuiEventListener> setupDisplay, List<EntryStack<?>> noticeStacks) {
        if (noticeStacks.isEmpty()) {
            return;
        }
        block0: for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            if (widget.getNoticeMark() != marker || widget.getEntries().size() <= 1) continue;
            for (EntryStack<?> noticeStack : noticeStacks) {
                EntryStack<?> stack = CollectionUtils.findFirstOrNullEqualsExact(widget.getEntries(), noticeStack);
                if (stack == null) continue;
                widget.clearStacks();
                widget.entry((EntryStack)stack);
                continue block0;
            }
        }
    }
}

