/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.ButtonArea;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.RecipeDisplayExporter;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultDisplayViewingScreen
extends AbstractDisplayViewingScreen {
    public static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final Map<Rectangle, List<Widget>> recipeBounds = Maps.newHashMap();
    private final List<TabWidget> tabs = Lists.newArrayList();
    public int page;
    public int categoryPages = -1;
    public boolean choosePageActivated = false;
    public DefaultDisplayChoosePageWidget choosePageWidget;
    @Nullable
    private Panel workingStationsBaseWidget;
    private Button recipeBack;
    private Button recipeNext;
    private Button categoryBack;
    private Button categoryNext;

    public DefaultDisplayViewingScreen(Map<DisplayCategory<?>, List<Display>> categoriesMap, @Nullable CategoryIdentifier<?> category) {
        super(categoriesMap, category, 5);
        this.bounds = new Rectangle(0, 0, 176, 150);
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    @Nullable
    public Panel getWorkingStationsBaseWidget() {
        return this.workingStationsBaseWidget;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.m_7856_();
            return true;
        }
        if (keyCode == 258 && !this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            boolean boolean_1;
            boolean bl = boolean_1 = !DefaultDisplayViewingScreen.m_96638_();
            if (!this.m_5755_(boolean_1)) {
                this.m_5755_(boolean_1);
            }
            return true;
        }
        if (this.choosePageActivated) {
            return this.choosePageWidget.m_7933_(keyCode, scanCode, modifiers);
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesKey(keyCode, scanCode)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        for (GuiEventListener element : this.m_6702_()) {
            if (!element.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (keyCode == 256 || this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            Minecraft.m_91087_().m_91152_(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesKey(keyCode, scanCode)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.f_96541_.m_91152_(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.f_96541_.m_91152_(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7856_() {
        super.m_7856_();
        boolean isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        int tabSize = isCompactTabs ? 24 : 28;
        this.m_6702_().clear();
        this.recipeBounds.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        int largestWidth = this.f_96543_ - 100;
        int largestHeight = Math.max(this.f_96544_ - 34 - 30, 100);
        int maxWidthDisplay = CollectionUtils.mapAndMax(this.getCurrentDisplayed(), this.getCurrentCategory()::getDisplayWidth, Comparator.naturalOrder()).orElse(150);
        int guiWidth = Math.max(maxWidthDisplay + 40, 190);
        this.tabsPerPage = Math.max(5, Mth.m_14107_((double)(((double)guiWidth - 20.0) / (double)tabSize)));
        if (this.categoryPages == -1) {
            this.categoryPages = Math.max(0, this.selectedCategoryIndex / this.tabsPerPage);
        }
        this.bounds = new Rectangle(this.f_96543_ / 2 - guiWidth / 2, this.f_96544_ / 2 - largestHeight / 2, guiWidth, largestHeight);
        if (ConfigObject.getInstance().isSubsetsEnabled()) {
            this.bounds.setLocation(this.bounds.getX(), this.bounds.getY() + 15);
            this.bounds.setSize(this.bounds.getWidth(), this.bounds.getHeight() - 10);
        }
        this.page = Mth.m_14045_((int)this.page, (int)0, (int)(this.getCurrentTotalPages() - 1));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x, this.bounds.y - 16, 10, 10), (Component)new TranslatableComponent("text.rei.left_arrow")).onClick(button -> {
            --this.categoryPages;
            if (this.categoryPages < 0) {
                this.categoryPages = Mth.m_14167_((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1;
            }
            this.m_7856_();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.widgets.add(Widgets.createButton(new Rectangle(this.bounds.x + this.bounds.width - 10, this.bounds.y - 16, 10, 10), (Component)new TranslatableComponent("text.rei.right_arrow")).onClick(button -> {
            ++this.categoryPages;
            if (this.categoryPages > Mth.m_14167_((float)((float)this.categories.size() / (float)this.tabsPerPage)) - 1) {
                this.categoryPages = 0;
            }
            this.m_7856_();
        }).enabled(this.categories.size() > this.tabsPerPage));
        this.categoryBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 5, 12, 12), (Component)new TranslatableComponent("text.rei.left_arrow")).onClick(button -> this.previousCategory()).tooltipLine((Component)new TranslatableComponent("text.rei.previous_category"));
        this.widgets.add(this.categoryBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 7), this.getCurrentCategory().getTitle(), clickableLabelWidget -> ViewSearchBuilder.builder().addAllCategories().open()).tooltipLine(I18n.m_118938_((String)"text.rei.view_all_categories", (Object[])new Object[0])));
        this.categoryNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 5, 12, 12), (Component)new TranslatableComponent("text.rei.right_arrow")).onClick(button -> this.nextCategory()).tooltipLine((Component)new TranslatableComponent("text.rei.next_category"));
        this.widgets.add(this.categoryNext);
        this.categoryBack.setEnabled(this.categories.size() > 1);
        this.categoryNext.setEnabled(this.categories.size() > 1);
        this.recipeBack = Widgets.createButton(new Rectangle(this.bounds.getX() + 5, this.bounds.getY() + 19, 12, 12), (Component)new TranslatableComponent("text.rei.left_arrow")).onClick(button -> {
            --this.page;
            if (this.page < 0) {
                this.page = this.getCurrentTotalPages() - 1;
            }
            this.m_7856_();
        }).tooltipLine((Component)new TranslatableComponent("text.rei.previous_page"));
        this.widgets.add(this.recipeBack);
        this.widgets.add(Widgets.createClickableLabel(new Point(this.bounds.getCenterX(), this.bounds.getY() + 21), NarratorChatListener.f_93310_, label -> {
            this.choosePageActivated = true;
            this.m_7856_();
        }).onRender((matrices, label) -> {
            label.setMessage((FormattedText)new ImmutableTextComponent(String.format("%d/%d", this.page + 1, this.getCurrentTotalPages())));
            label.setClickable(this.getCurrentTotalPages() > 1);
        }).tooltipSupplier(label -> label.isClickable() ? I18n.m_118938_((String)"text.rei.choose_page", (Object[])new Object[0]) : null));
        this.recipeNext = Widgets.createButton(new Rectangle(this.bounds.getMaxX() - 17, this.bounds.getY() + 19, 12, 12), (Component)new TranslatableComponent("text.rei.right_arrow")).onClick(button -> {
            ++this.page;
            if (this.page >= this.getCurrentTotalPages()) {
                this.page = 0;
            }
            this.m_7856_();
        }).tooltipLine((Component)new TranslatableComponent("text.rei.next_page"));
        this.widgets.add(this.recipeNext);
        this.recipeBack.setEnabled(this.getCurrentTotalPages() > 1);
        this.recipeNext.setEnabled(this.getCurrentTotalPages() > 1);
        int tabV = isCompactTabs ? 166 : 192;
        for (int i = 0; i < this.tabsPerPage; ++i) {
            int j = i + this.categoryPages * this.tabsPerPage;
            if (this.categories.size() <= j) continue;
            TabWidget tab = TabWidget.create(i, tabSize, this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * this.tabsPerPage, this.tabsPerPage) * tabSize / 2, this.bounds.y, 0, tabV, widget -> {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                if (widget.getId() + this.categoryPages * this.tabsPerPage == this.selectedCategoryIndex) {
                    return false;
                }
                ClientHelperImpl.getInstance().openRecipeViewingScreen(this.categoryMap, ((DisplayCategory)this.categories.get(widget.getId() + this.categoryPages * this.tabsPerPage)).getCategoryIdentifier(), this.ingredientStackToNotice, this.resultStackToNotice);
                return true;
            });
            this.tabs.add(tab);
            tab.setRenderer((DisplayCategory)this.categories.get(j), ((DisplayCategory)this.categories.get(j)).getIcon(), ((DisplayCategory)this.categories.get(j)).getTitle(), tab.getId() + this.categoryPages * this.tabsPerPage == this.selectedCategoryIndex);
        }
        Optional<ButtonArea> supplier = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getPlusButtonArea();
        int recipeHeight = this.getCurrentCategory().getDisplayHeight();
        List<Display> currentDisplayed = this.getCurrentDisplayed();
        for (int i = 0; i < currentDisplayed.size(); ++i) {
            Display display = currentDisplayed.get(i);
            Supplier<Display> displaySupplier = () -> display;
            int displayWidth = this.getCurrentCategory().getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle(this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().getCenterY() + 16 - recipeHeight * (this.getRecipesPerPage() + 1) / 2 - 2 * (this.getRecipesPerPage() + 1) + recipeHeight * i + 4 * i, displayWidth, recipeHeight);
            List<Widget> setupDisplay = this.getCurrentCategory().setupDisplay(display, displayBounds);
            this.transformIngredientNotice(setupDisplay, this.ingredientStackToNotice);
            this.transformResultNotice(setupDisplay, this.resultStackToNotice);
            this.recipeBounds.put(displayBounds, setupDisplay);
            this.widgets.addAll(setupDisplay);
            if (!supplier.isPresent() || supplier.get().get(displayBounds) == null) continue;
            this.widgets.add(InternalWidgets.createAutoCraftingButtonWidget(displayBounds, supplier.get().get(displayBounds), (Component)new TextComponent(supplier.get().getButtonText()), displaySupplier, setupDisplay, this.getCurrentCategory()));
        }
        this.choosePageWidget = this.choosePageActivated ? new DefaultDisplayChoosePageWidget(this, this.page, this.getCurrentTotalPages()) : null;
        this.workingStationsBaseWidget = null;
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCurrentCategoryId()).getWorkstations();
        if (!workstations.isEmpty()) {
            int hh = Mth.m_14143_((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workstations.size());
            int innerWidth = Mth.m_14167_((float)((float)workstations.size() / (float)hh));
            int xx = this.bounds.x - (8 + innerWidth * 16) + 6;
            int yy = this.bounds.y + 16;
            this.workingStationsBaseWidget = Widgets.createCategoryBase(new Rectangle(xx - 5, yy - 5, 15 + innerWidth * 16, 10 + actualHeight * 16));
            this.preWidgets.add(this.workingStationsBaseWidget);
            this.preWidgets.add(Widgets.createSlotBase(new Rectangle(xx - 1, yy - 1, innerWidth * 16 + 2, actualHeight * 16 + 2)));
            int index = 0;
            xx += (innerWidth - 1) * 16;
            for (EntryIngredient workingStation : workstations) {
                this.preWidgets.add(new WorkstationSlotWidget(xx, yy, workingStation));
                yy += 16;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 16;
            }
        }
        this._children().addAll(this.tabs);
        this._children().addAll(this.widgets);
        this._children().addAll(this.preWidgets);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<Display> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        List displays = (List)this.categoryMap.get(this.getCurrentCategory());
        for (int i = 0; i <= recipesPerPage; ++i) {
            if (this.page * (recipesPerPage + 1) + i >= displays.size()) continue;
            list.add((Display)displays.get(this.page * (recipesPerPage + 1) + i));
        }
        return list;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        DisplayCategory<Display> selectedCategory = this.getCurrentCategory();
        if (selectedCategory.getFixedDisplaysPerPage() > 0) {
            return selectedCategory.getFixedDisplaysPerPage() - 1;
        }
        int height = selectedCategory.getDisplayHeight();
        return Mth.m_14045_((int)(Mth.m_14107_((double)(((double)this.bounds.getHeight() - 36.0) / ((double)height + 4.0))) - 1), (int)0, (int)Math.min(ConfigObject.getInstance().getMaxRecipePerPage() - 1, selectedCategory.getMaximumDisplaysPerPage() - 1));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_93179_(matrices, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        for (Widget widget : this.preWidgets) {
            widget.m_6305_(matrices, mouseX, mouseY, delta);
        }
        PanelWidget.render(matrices, this.bounds, -1);
        if (REIRuntime.getInstance().isDarkThemeEnabled()) {
            DefaultDisplayViewingScreen.m_93172_((PoseStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-12566464);
            DefaultDisplayViewingScreen.m_93172_((PoseStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 30), (int)-12566464);
        } else {
            DefaultDisplayViewingScreen.m_93172_((PoseStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-6381922);
            DefaultDisplayViewingScreen.m_93172_((PoseStack)matrices, (int)(this.bounds.x + 17), (int)(this.bounds.y + 19), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 31), (int)-6381922);
        }
        for (TabWidget tab : this.tabs) {
            if (tab.isSelected()) continue;
            tab.m_6305_(matrices, mouseX, mouseY, delta);
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.m_6305_(matrices, mouseX, mouseY, delta);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TabWidget tab : this.tabs) {
            if (!tab.isSelected()) continue;
            tab.m_6305_(matrices, mouseX, mouseY, delta);
        }
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesCurrentKey() || export.matchesCurrentMouse()) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                this.m_93250_(470);
                if (bounds.contains(mouseX, mouseY)) {
                    this.m_93179_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 1744822402, 1744822402);
                    TranslatableComponent text = new TranslatableComponent("text.rei.release_export", new Object[]{export.getLocalizedName().m_6879_().getString()});
                    MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                    matrices.m_85836_();
                    matrices.m_85837_(0.0, 0.0, 480.0);
                    Matrix4f matrix4f = matrices.m_85850_().m_85861_();
                    this.f_96547_.m_92733_(text.m_7532_(), (float)bounds.getCenterX() - (float)this.f_96547_.m_92852_((FormattedText)text) / 2.0f, (float)bounds.getCenterY() - 4.5f, -16777216, false, matrix4f, (MultiBufferSource)immediate, false, 0, 0xF000F0);
                    immediate.m_109911_();
                    matrices.m_85849_();
                } else {
                    this.m_93179_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0x67FFFFFF, 0x67FFFFFF);
                }
                this.m_93250_(0);
            }
        }
        if (this.choosePageActivated) {
            this.m_93250_(500);
            this.m_93179_(matrices, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            this.m_93250_(0);
            this.choosePageWidget.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesKey(keyCode, scanCode)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (!bounds.contains(PointHelper.ofMouse())) continue;
                RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                break;
            }
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public int getCurrentTotalPages() {
        return this.getTotalPages(this.selectedCategoryIndex);
    }

    public int getTotalPages(int categoryIndex) {
        return Mth.m_14165_((double)((double)((List)this.categoryMap.get(this.categories.get(categoryIndex))).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public boolean m_5534_(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.choosePageWidget.m_5534_(char_1, int_1);
        }
        for (GuiEventListener listener : this.m_6702_()) {
            if (!listener.m_5534_(char_1, int_1)) continue;
            return true;
        }
        return super.m_5534_(char_1, int_1);
    }

    public boolean m_7979_(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.choosePageWidget.m_7979_(double_1, double_2, int_1, double_3, double_4);
        }
        for (GuiEventListener entry : this.m_6702_()) {
            if (!entry.m_7979_(double_1, double_2, int_1, double_3, double_4)) continue;
            return true;
        }
        return super.m_7979_(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.choosePageActivated) {
            return this.choosePageWidget.m_6348_(mouseX, mouseY, button);
        }
        ModifierKeyCode export = ConfigObject.getInstance().getExportImageKeybind();
        if (export.matchesMouse(button)) {
            for (Map.Entry<Rectangle, List<Widget>> entry : this.recipeBounds.entrySet()) {
                Rectangle bounds = entry.getKey();
                if (!bounds.contains(PointHelper.ofMouse())) continue;
                RecipeDisplayExporter.exportRecipeDisplay(bounds, entry.getValue());
                break;
            }
        }
        for (GuiEventListener entry : this.m_6702_()) {
            if (!entry.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        REIRuntimeImpl.isWithinRecipeViewingScreen = true;
        for (GuiEventListener listener : this.m_6702_()) {
            if (!listener.m_6050_(mouseX, mouseY, amount)) continue;
            REIRuntimeImpl.isWithinRecipeViewingScreen = false;
            return true;
        }
        REIRuntimeImpl.isWithinRecipeViewingScreen = false;
        if (this.getBounds().contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            } else if (amount < 0.0 && this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(PointHelper.ofMouse())) {
            if (amount > 0.0 && this.categoryBack.isEnabled()) {
                this.categoryBack.onClick();
            } else if (amount < 0.0 && this.categoryNext.isEnabled()) {
                this.categoryNext.onClick();
            }
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.choosePageActivated) {
            if (this.choosePageWidget.containsMouse(mouseX, mouseY)) {
                return this.choosePageWidget.m_6375_(mouseX, mouseY, button);
            }
            this.choosePageActivated = false;
            this.m_7856_();
            return false;
        }
        if (ConfigObject.getInstance().getNextPageKeybind().matchesMouse(button)) {
            if (this.recipeNext.isEnabled()) {
                this.recipeNext.onClick();
            }
            return this.recipeNext.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousPageKeybind().matchesMouse(button)) {
            if (this.recipeBack.isEnabled()) {
                this.recipeBack.onClick();
            }
            return this.recipeBack.isEnabled();
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesMouse(button)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.f_96541_.m_91152_(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.f_96541_.m_91152_(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public GuiEventListener m_7222_() {
        if (this.choosePageActivated) {
            return this.choosePageWidget;
        }
        return super.m_7222_();
    }

    public static class WorkstationSlotWidget
    extends EntryWidget {
        public WorkstationSlotWidget(int x, int y, EntryIngredient widgets) {
            super(new Point(x, y));
            this.entries((Collection)widgets);
            this.noBackground();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return this.getInnerBounds().contains(mouseX, mouseY);
        }
    }
}

