/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.fluid.FluidStack;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class EntryListEntryWidget
extends EntryWidget {
    public int backupY;

    protected EntryListEntryWidget(Point point, int entrySize) {
        super(point);
        this.backupY = point.y;
        this.getBounds().width = this.getBounds().height = entrySize;
    }

    @Override
    protected void drawHighlighted(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.getCurrentEntry().isEmpty()) {
            super.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    public void queueTooltip(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (ClientHelper.getInstance().isCheating() && !this.minecraft.f_91074_.f_36096_.m_142621_().m_41619_()) {
            return;
        }
        super.queueTooltip(matrices, mouseX, mouseY, delta);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        if (this.containsMouse(mouseX, mouseY) && this.wasClicked()) {
            if (this.doAction(mouseX, mouseY, button)) {
                return true;
            }
            this.wasClicked = true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected boolean doAction(double mouseX, double mouseY, int button) {
        if (!ClientHelper.getInstance().isCheating()) {
            return false;
        }
        EntryStack<Object> entry = this.getCurrentEntry().copy();
        if (!entry.isEmpty()) {
            FluidStack value;
            Item bucketItem;
            if (entry.getValueType() == FluidStack.class && (bucketItem = (value = (FluidStack)entry.getValue()).getFluid().m_6859_()) != null) {
                entry = EntryStacks.of((ItemLike)bucketItem);
            }
            if (entry.getValueType() == ItemStack.class) {
                ((ItemStack)entry.castValue()).m_41764_(button != 1 && !Screen.m_96638_() ? 1 : ((ItemStack)entry.castValue()).m_41741_());
            }
            return ClientHelper.getInstance().tryCheatingEntry(entry);
        }
        return false;
    }

    @Override
    protected boolean cancelDeleteItems(EntryStack<?> stack) {
        EntryStack<Object> entry;
        if (!this.interactable || !ConfigObject.getInstance().isGrabbingItems()) {
            return super.cancelDeleteItems(stack);
        }
        if (ClientHelper.getInstance().isCheating() && !(entry = this.getCurrentEntry().copy()).isEmpty()) {
            FluidStack value;
            Item bucketItem;
            if (entry.getValueType() == FluidStack.class && (bucketItem = (value = (FluidStack)entry.getValue()).getFluid().m_6859_()) != null) {
                entry = EntryStacks.of((ItemLike)bucketItem);
            }
            return EntryStacks.equalsExact(entry, stack);
        }
        return super.cancelDeleteItems(stack);
    }
}

