/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.EntryPanelOrdering;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryListEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.impl.client.search.AsyncSearchManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EntryListWidget
extends WidgetWithBounds
implements OverlayListWidget {
    static final Comparator<? super EntryStack<?>> ENTRY_NAME_COMPARER = Comparator.comparing(stack -> stack.asFormatStrippedText().getString());
    static final Comparator<? super EntryStack<?>> ENTRY_GROUP_COMPARER = Comparator.comparingInt(stack -> {
        CreativeModeTab group;
        if (stack.getType() == VanillaEntryTypes.ITEM && (group = ((ItemStack)stack.getValue()).m_41720_().m_41471_()) != null) {
            return group.m_40775_();
        }
        return Integer.MAX_VALUE;
    });
    private static final int SIZE = 18;
    private static final boolean LAZY = true;
    private static int page;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return Mth.m_14167_((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount) / ((float)EntryListWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };
    protected int blockedCount;
    private boolean debugTime;
    private double lastAverageDebugTime;
    private double averageDebugTime;
    private double lastTotalDebugTime;
    private double totalDebugTime;
    private double totalDebugTimeDelta;
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack<?>> allStacks = null;
    private List<EntryListEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> widgets = Collections.emptyList();
    private AsyncSearchManager searchManager = AsyncSearchManager.createDefault();

    public static int entrySize() {
        return Mth.m_14165_((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height, Rectangle listArea) {
        Minecraft instance = Minecraft.m_91087_();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.f_91080_)) {
            InteractionResult fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == InteractionResult.PASS) continue;
            return fit == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static InteractionResult canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        InteractionResult fit = decider.isInZone(left, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundaries()));
        int heightReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundaries()));
        bounds.x += widthReduction;
        bounds.width -= widthReduction;
        bounds.y += heightReduction / 2;
        bounds.height -= heightReduction;
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(Mth.m_14143_((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.bounds.contains(mouseX, mouseY)) {
            if (Screen.m_96637_()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    return true;
                }
            } else if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        EntryListWidget.page = page;
    }

    public void previousPage() {
        --page;
    }

    public void nextPage() {
        ++page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return Mth.m_14167_((float)((float)this.allStacks.size() / (float)this.entries.size()));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        MutableInt size = new MutableInt();
        MutableLong time = new MutableLong();
        long totalTimeStart = this.debugTime ? System.nanoTime() : 0L;
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            this.blockedCount = 0;
            BatchedEntryRendererManager batchedEntryRendererManager = new BatchedEntryRendererManager();
            int i = nextIndex;
            for (int cont = nextIndex; cont < this.entries.size(); ++cont) {
                EntryListEntry entry = this.entries.get(cont);
                Rectangle entryBounds = entry.getBounds();
                entryBounds.y = (int)((double)entry.backupY - this.scrolling.scrollAmount);
                if (entryBounds.y > this.bounds.getMaxY() || this.allStacks.size() <= i) break;
                if (EntryListWidget.notSteppingOnExclusionZones(entryBounds.x, entryBounds.y, entryBounds.width, entryBounds.height, this.innerBounds)) {
                    EntryStack<?> stack = this.allStacks.get(i++);
                    entry.clearStacks();
                    if (stack.isEmpty()) continue;
                    entry.entry((EntryStack)stack);
                    batchedEntryRendererManager.add(entry);
                    continue;
                }
                ++this.blockedCount;
            }
            batchedEntryRendererManager.render(this.debugTime, size, time, matrices, mouseX, mouseY, delta);
            this.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.scrolling.getMaxScroll() > 0) {
                this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
        } else {
            for (Widget widget : this.renders) {
                widget.m_6305_(matrices, mouseX, mouseY, delta);
            }
            new BatchedEntryRendererManager(this.entries).render(this.debugTime, size, time, matrices, mouseX, mouseY, delta);
        }
        if (this.debugTime) {
            long totalTime = System.nanoTime() - totalTimeStart;
            this.averageDebugTime += (double)time.getValue().longValue() / size.doubleValue() * (double)delta;
            this.totalDebugTime += (double)totalTime / 1000000.0 * (double)delta;
            this.totalDebugTimeDelta += (double)delta;
            if (this.totalDebugTimeDelta >= 20.0) {
                this.lastAverageDebugTime = this.averageDebugTime / this.totalDebugTimeDelta;
                this.lastTotalDebugTime = this.totalDebugTime / this.totalDebugTimeDelta;
                this.averageDebugTime = 0.0;
                this.totalDebugTime = 0.0;
                this.totalDebugTimeDelta = 0.0;
            } else if (this.lastAverageDebugTime == 0.0) {
                this.lastAverageDebugTime = (double)time.getValue().longValue() / size.doubleValue();
                this.totalDebugTime = (double)totalTime / 1000000.0;
            }
            int n = this.getZ();
            this.setZ(500);
            TextComponent debugText = new TextComponent(String.format("%d entries, avg. %.0fns, ttl. %.2fms, %s fps", size.getValue(), this.lastAverageDebugTime, this.lastTotalDebugTime, this.minecraft.f_90977_.split(" ")[0]));
            int stringWidth = this.font.m_92852_((FormattedText)debugText);
            int n2 = Math.min(this.bounds.x, this.minecraft.f_91080_.f_96543_ - stringWidth - 2);
            int n3 = this.bounds.y;
            int n4 = this.bounds.x + stringWidth + 2;
            int n5 = this.bounds.y;
            Objects.requireNonNull(this.font);
            this.m_93179_(matrices, n2, n3, n4, n5 + 9 + 2, -16777216, -16777216);
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, (double)this.getZ());
            Matrix4f matrix = matrices.m_85850_().m_85861_();
            this.font.m_92733_(debugText.m_7532_(), (float)Math.min(this.bounds.x + 2, this.minecraft.f_91080_.f_96543_ - stringWidth), (float)(this.bounds.y + 2), -1, false, matrix, (MultiBufferSource)immediate, false, 0, 0xF000F0);
            immediate.m_109911_();
            this.setZ(n);
            matrices.m_85849_();
        }
        if (this.containsMouse(mouseX, mouseY) && ClientHelper.getInstance().isCheating() && !this.minecraft.f_91074_.f_36096_.m_142621_().m_41619_() && ClientHelperImpl.getInstance().canDeleteItems()) {
            Item bucketItem;
            EntryStack<ItemStack> stack = EntryStacks.of(this.minecraft.f_91074_.f_36096_.m_142621_().m_41777_());
            if (stack.getValueType() == FluidStack.class && (bucketItem = ((FluidStack)stack.getValue()).getFluid().m_6859_()) != null) {
                stack = EntryStacks.of((ItemLike)bucketItem);
            }
            for (Widget widget : this.m_6702_()) {
                EntryWidget widget2;
                Widget widget3;
                if (!widget.containsMouse(mouseX, mouseY) || !((widget3 = widget) instanceof EntryWidget) || !(widget2 = (EntryWidget)widget3).cancelDeleteItems(stack)) continue;
                return;
            }
            Tooltip.create(new Component[]{new TranslatableComponent("text.rei.delete_items")}).queue();
        }
    }

    private int getScrollbarMinX() {
        if (ConfigObject.getInstance().isLeftHandSidePanel()) {
            return this.bounds.x + 1;
        }
        return this.bounds.getMaxX() - 7;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy, ConfigObject.getInstance().doesSnapToRows(), (double)EntryListWidget.entrySize())) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        if (ConfigObject.getInstance().doesSnapToRows() && this.scrolling.scrollTarget >= 0.0 && this.scrolling.scrollTarget <= (double)this.scrolling.getMaxScroll()) {
            double nearestRow = (double)Math.round(this.scrolling.scrollTarget / (double)EntryListWidget.entrySize()) * (double)EntryListWidget.entrySize();
            this.scrolling.scrollTarget = !DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals((double)this.scrolling.scrollTarget, (double)nearestRow, (double)0.001f) ? (this.scrolling.scrollTarget += (nearestRow - this.scrolling.scrollTarget) * Math.min((double)delta / 2.0, 1.0)) : nearestRow;
        }
        this.scrolling.updatePosition(delta);
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (this.containsMouse(PointHelper.ofMouse())) {
            for (Widget widget : this.widgets) {
                if (!widget.m_7933_(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(String searchTerm) {
        this.bounds = REIRuntime.getInstance().calculateEntryListArea();
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (this.allStacks == null || ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.renders = Lists.newArrayList();
            page = Math.max(page, 0);
            ArrayList entries = Lists.newArrayList();
            int width = this.innerBounds.width / entrySize;
            int height = this.innerBounds.height / entrySize;
            for (int currentY = 0; currentY < height; ++currentY) {
                for (int currentX = 0; currentX < width; ++currentX) {
                    int slotX = currentX * entrySize + this.innerBounds.x;
                    int slotY = currentY * entrySize + this.innerBounds.y;
                    if (!EntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize, this.innerBounds)) continue;
                    entries.add((EntryListEntry)new EntryListEntry(slotX, slotY, entrySize).noBackground());
                }
            }
            page = Math.max(Math.min(page, this.getTotalPages() - 1), 0);
            List subList = this.allStacks.stream().skip(Math.max(0, page * entries.size())).limit(Math.max(0, entries.size() - Math.max(0, -page * entries.size()))).collect(Collectors.toList());
            for (int i = 0; i < subList.size(); ++i) {
                EntryStack stack = (EntryStack)subList.get(i);
                ((EntryListEntry)entries.get(i + Math.max(0, -page * entries.size()))).clearStacks().entry(stack);
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        } else {
            page = 0;
            int width = this.innerBounds.width / entrySize;
            int pageHeight = this.innerBounds.height / entrySize;
            int slotsToPrepare = Math.max(this.allStacks.size() * 3, width * pageHeight * 3);
            int currentX = 0;
            int currentY = 0;
            ArrayList entries = Lists.newArrayList();
            for (int i = 0; i < slotsToPrepare; ++i) {
                int xPos = currentX * entrySize + this.innerBounds.x;
                int yPos = currentY * entrySize + this.innerBounds.y;
                entries.add((EntryListEntry)new EntryListEntry(xPos, yPos, entrySize).noBackground());
                if (++currentX < width) continue;
                currentX = 0;
                ++currentY;
            }
            this.entries = entries;
            this.widgets = Lists.newArrayList(this.renders);
            this.widgets.addAll(entries);
        }
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateEntriesPosition(entry -> true);
        }
    }

    @ApiStatus.Internal
    public List<EntryStack<?>> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (ignoreLastSearch) {
            this.searchManager.markDirty();
        }
        this.searchManager.updateFilter(searchTerm);
        if (this.searchManager.isDirty()) {
            List<EntryStack<?>> list = this.searchManager.get();
            EntryPanelOrdering ordering = ConfigObject.getInstance().getItemListOrdering();
            if (ordering == EntryPanelOrdering.NAME) {
                list.sort(ENTRY_NAME_COMPARER);
            }
            if (ordering == EntryPanelOrdering.GROUPS) {
                list.sort(ENTRY_GROUP_COMPARER);
            }
            if (!ConfigObject.getInstance().isItemListAscending()) {
                Collections.reverse(list);
            }
            this.allStacks = list;
        }
        this.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info("Search Used: %s", (Object)stopwatch.stop().toString());
        }
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        return this.searchManager.matches(stack);
    }

    public List<? extends Widget> m_6702_() {
        return this.widgets;
    }

    public boolean m_6375_(double double_1, double double_2, int int_1) {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.scrolling.updateDraggingState(double_1, double_2, int_1)) {
            return true;
        }
        for (Widget widget : this.m_6702_()) {
            if (!widget.m_6375_(double_1, double_2, int_1)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            LocalPlayer player = this.minecraft.f_91074_;
            if (ClientHelper.getInstance().isCheating() && player != null && player.f_36096_ != null && !player.f_36096_.m_142621_().m_41619_() && ClientHelperImpl.getInstance().canDeleteItems()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            for (Widget widget : this.m_6702_()) {
                if (!widget.m_6348_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = PointHelper.ofMouse();
        if (this.containsMouse(mouse)) {
            for (EntryListEntry entry : this.entries) {
                EntryStack<?> currentEntry = entry.getCurrentEntry();
                if (currentEntry.isEmpty() || !entry.containsMouse(mouse)) continue;
                return currentEntry.copy();
            }
        }
        return EntryStack.empty();
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            return this.entries.stream().skip(nextIndex).filter(entry -> entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter((Predicate<EntryStack>)Predicates.not(EntryStack::isEmpty));
        }
        return this.entries.stream().map(EntryWidget::getCurrentEntry);
    }

    private class EntryListEntry
    extends EntryListEntryWidget {
        private EntryListEntry(int x, int y, int entrySize) {
            super(new Point(x, y), entrySize);
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && EntryListWidget.this.bounds.contains(mouseX, mouseY);
        }
    }
}

