/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.TransferDisplayCategory;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.toast.CopyRecipeIdentifierToast;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ArrowWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.BurningFireWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.ButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.DrawableWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.FillRectangleDrawableConsumer;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.LabelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.PanelWidget;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TexturedDrawableConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class InternalWidgets {
    private InternalWidgets() {
    }

    public static Widget createAutoCraftingButtonWidget(Rectangle displayBounds, Rectangle rectangle, Component text, final Supplier<Display> displaySupplier, List<Widget> setupDisplay, DisplayCategory<?> category) {
        AbstractContainerScreen<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        boolean[] visible = new boolean[]{false};
        List[] errorTooltip = new List[]{null};
        Button autoCraftingButton = Widgets.createButton(rectangle, text).focusable(false).onClick(button -> {
            TransferHandler.Context context = TransferHandler.Context.create(true, containerScreen, (Display)displaySupplier.get());
            for (TransferHandler autoTransferHandler : TransferHandlerRegistry.getInstance()) {
                try {
                    TransferHandler.Result result = autoTransferHandler.handle(context);
                    if (!result.isBlocking()) continue;
                    if (!result.isReturningToScreen()) {
                        return;
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Minecraft.m_91087_().m_91152_((Screen)containerScreen);
            REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
        }).onRender((matrices, button) -> {
            button.setEnabled(false);
            if (containerScreen == null) {
                button.setTint(0);
                return;
            }
            ArrayList error = null;
            int color = 0;
            visible[0] = false;
            IntList redSlots = null;
            TransferHandler.Context context = TransferHandler.Context.create(false, containerScreen, (Display)displaySupplier.get());
            for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
                try {
                    TransferHandler.Result result = transferHandler.handle(context);
                    if (result.isApplicable()) {
                        visible[0] = true;
                    }
                    if (result.isSuccessful()) {
                        button.setEnabled(true);
                        error = null;
                        color = 0;
                        redSlots = null;
                    } else if (result.isApplicable()) {
                        if (error == null) {
                            error = Lists.newArrayList();
                        }
                        error.add(result.getError());
                        color = result.getColor();
                        if (result.getIntegers() != null && !result.getIntegers().isEmpty()) {
                            redSlots = result.getIntegers();
                        }
                    }
                    if (!result.isBlocking()) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!visible[0]) {
                button.setEnabled(false);
                if (error == null) {
                    error = Lists.newArrayList();
                } else {
                    error.clear();
                }
                error.add(new TranslatableComponent("error.rei.no.handlers.applicable"));
            }
            if ((button.containsMouse(PointHelper.ofMouse()) || button.isFocused()) && category instanceof TransferDisplayCategory && redSlots != null) {
                ((TransferDisplayCategory)category).renderRedSlots((PoseStack)matrices, setupDisplay, displayBounds, (Display)displaySupplier.get(), redSlots);
            }
            List list = errorTooltip[0] = error == null || error.isEmpty() ? null : Lists.newArrayList();
            if (errorTooltip[0] != null) {
                for (Component s : error) {
                    if (CollectionUtils.anyMatch(errorTooltip[0], ss -> ss.getString().equalsIgnoreCase(s.getString()))) continue;
                    errorTooltip[0].add(s);
                }
            }
            button.setTint(color);
        }).textColor((button, mouse) -> {
            if (!visible[0]) {
                return 0xA0A0A0;
            }
            if (button.isEnabled() && (button.containsMouse((Point)mouse) || button.isFocused())) {
                return 0xFFFFA0;
            }
            return 0xE0E0E0;
        }).textureId((button, mouse) -> !visible[0] ? 0 : ((button.containsMouse((Point)mouse) || button.isFocused()) && button.isEnabled() ? 4 : 1)).tooltipSupplier(button -> {
            ArrayList<Object> str = new ArrayList<Object>();
            if (errorTooltip[0] == null) {
                if (((Boolean)ClientHelperImpl.getInstance().isYog.m_13971_()).booleanValue()) {
                    str.add(new TranslatableComponent("text.auto_craft.move_items.yog"));
                } else {
                    str.add(new TranslatableComponent("text.auto_craft.move_items"));
                }
            } else if (errorTooltip[0].size() > 1) {
                str.add(new TranslatableComponent("error.rei.multi.errors").m_130940_(ChatFormatting.RED));
                for (Component component : errorTooltip[0]) {
                    str.add(new TranslatableComponent("- ").m_130940_(ChatFormatting.RED).m_7220_((Component)component.m_6881_().m_130940_(ChatFormatting.RED)));
                }
            } else if (errorTooltip[0].size() == 1) {
                str.add(((Component)errorTooltip[0].get(0)).m_6881_().m_130940_(ChatFormatting.RED));
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_ && ((Display)displaySupplier.get()).getDisplayLocation().isPresent()) {
                str.add(new TranslatableComponent("text.rei.recipe_id", new Object[]{"", new TextComponent(((Display)displaySupplier.get()).getDisplayLocation().get().toString()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GRAY));
            }
            return str.toArray(new Component[0]);
        });
        return new DelegateWidget(autoCraftingButton){

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                if (((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesKey(keyCode, scanCode) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.f_91068_.m_90911_(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.m_118938_((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.m_118938_((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (((Display)displaySupplier.get()).getDisplayLocation().isPresent() && ConfigObject.getInstance().getCopyRecipeIdentifierKeybind().matchesMouse(button) && this.containsMouse(PointHelper.ofMouse())) {
                    this.minecraft.f_91068_.m_90911_(((Display)displaySupplier.get()).getDisplayLocation().get().toString());
                    if (ConfigObject.getInstance().isToastDisplayedOnCopyIdentifier()) {
                        CopyRecipeIdentifierToast.addToast(I18n.m_118938_((String)"msg.rei.copied_recipe_id", (Object[])new Object[0]), I18n.m_118938_((String)"msg.rei.recipe_id_details", (Object[])new Object[]{((Display)displaySupplier.get()).getDisplayLocation().get().toString()}));
                    }
                    return true;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
    }

    public static WidgetWithBounds wrapLateRenderable(Widget widget) {
        return new LateRenderableWidget(widget);
    }

    public static Widget concatWidgets(Widget widget1, Widget widget2) {
        return new MergedWidget(widget2, widget1);
    }

    public static void attach() {
        ClientInternals.attachInstance(new WidgetsProvider(), ClientInternals.WidgetsProvider.class);
    }

    private static class LateRenderableWidget
    extends DelegateWidget
    implements LateRenderable {
        private LateRenderableWidget(Widget widget) {
            super(widget);
        }
    }

    private static class MergedWidget
    extends Widget {
        private final List<Widget> widgets;

        public MergedWidget(Widget widget1, Widget widget2) {
            this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            for (Widget widget : this.widgets) {
                widget.setZ(this.getZ());
                widget.m_6305_(matrices, mouseX, mouseY, delta);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            for (Widget widget : this.widgets) {
                if (!widget.m_6050_(mouseX, mouseY, amount)) continue;
                return true;
            }
            return false;
        }
    }

    private static class WidgetsProvider
    implements ClientInternals.WidgetsProvider {
        private WidgetsProvider() {
        }

        @Override
        public boolean isRenderingPanel(Panel panel) {
            return PanelWidget.isRendering(panel);
        }

        @Override
        public Widget createDrawableWidget(DrawableConsumer drawable) {
            return new DrawableWidget(drawable);
        }

        @Override
        public Slot createSlot(Point point) {
            return new EntryWidget(point);
        }

        @Override
        public Slot createSlot(Rectangle bounds) {
            return new EntryWidget(bounds);
        }

        @Override
        public Button createButton(Rectangle bounds, Component text) {
            return new ButtonWidget(bounds, text);
        }

        @Override
        public Panel createPanelWidget(Rectangle bounds) {
            return new PanelWidget(bounds);
        }

        @Override
        public Label createLabel(Point point, FormattedText text) {
            return new LabelWidget(point, text);
        }

        @Override
        public Arrow createArrow(Rectangle rectangle) {
            return new ArrowWidget(rectangle);
        }

        @Override
        public BurningFire createBurningFire(Rectangle rectangle) {
            return new BurningFireWidget(rectangle);
        }

        @Override
        public DrawableConsumer createTexturedConsumer(ResourceLocation texture, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
            return new TexturedDrawableConsumer(texture, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight);
        }

        @Override
        public DrawableConsumer createFillRectangleConsumer(Rectangle rectangle, int color) {
            return new FillRectangleDrawableConsumer(rectangle, color);
        }
    }
}

