/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TabWidget
extends WidgetWithBounds
implements DraggableStackProviderWidget {
    public static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final ResourceLocation CHEST_GUI_TEXTURE_DARK = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    public boolean selected = false;
    public Renderer renderer;
    public int id;
    public Component categoryName;
    public Rectangle bounds;
    public DisplayCategory<?> category;
    public int u;
    public int v;
    @Nullable
    private Predicate<TabWidget> onClick;

    private TabWidget(int id, Rectangle bounds, int u, int v, @Nullable Predicate<TabWidget> onClick) {
        this.id = id;
        this.bounds = bounds;
        this.u = u;
        this.v = v;
        this.onClick = onClick;
    }

    @ApiStatus.Internal
    public static TabWidget create(int id, int tabSize, int leftX, int bottomY, int u, int v, @Nullable Predicate<TabWidget> onClick) {
        return new TabWidget(id, new Rectangle(leftX + id * tabSize, bottomY - tabSize, tabSize, tabSize), u, v, onClick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return button == 0 && this.containsMouse(mouseX, mouseY) && this.onClick.test(this);
    }

    public void setRenderer(DisplayCategory<?> category, Renderer renderer, Component categoryName, boolean selected) {
        this.renderer = renderer;
        this.category = category;
        this.selected = selected;
        this.categoryName = categoryName;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getId() {
        return this.id;
    }

    public boolean isShown() {
        return this.renderer != null;
    }

    public List<Widget> m_6702_() {
        return Collections.emptyList();
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.renderer != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)(REIRuntime.getInstance().isDarkThemeEnabled() ? CHEST_GUI_TEXTURE_DARK : CHEST_GUI_TEXTURE));
            this.m_93228_(matrices, this.bounds.x, this.bounds.y + 2, this.u + (this.selected ? this.bounds.width : 0), this.v, this.bounds.width, this.selected ? this.bounds.height + 2 : this.bounds.height - 1);
            this.renderer.setZ(100);
            this.renderer.render(matrices, new Rectangle(this.bounds.getCenterX() - 8, this.bounds.getCenterY() - 5, 16, 16), mouseX, mouseY, delta);
            if (this.containsMouse(mouseX, mouseY)) {
                this.drawTooltip();
            }
        }
    }

    private void drawTooltip() {
        if (this.minecraft.f_91066_.f_92125_) {
            Tooltip.create(new Component[]{this.categoryName, new TextComponent(this.category.getIdentifier().toString()).m_130940_(ChatFormatting.DARK_GRAY), ClientHelper.getInstance().getFormattedModFromIdentifier(this.category.getIdentifier())}).queue();
        } else {
            Tooltip.create(this.categoryName, ClientHelper.getInstance().getFormattedModFromIdentifier(this.category.getIdentifier())).queue();
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(final DraggingContext<Screen> context, double mouseX, double mouseY) {
        Renderer renderer;
        if (this.isShown() && (renderer = this.renderer) instanceof EntryStack) {
            final EntryStack entryStack = (EntryStack)renderer;
            if (this.containsMouse(mouseX, mouseY)) {
                return new DraggableStack(){
                    EntryStack<?> stack;
                    {
                        this.stack = entryStack.copy();
                    }

                    @Override
                    public EntryStack<?> getStack() {
                        return this.stack;
                    }

                    @Override
                    public void drag() {
                    }

                    @Override
                    public void release(boolean accepted) {
                        if (!accepted) {
                            context.renderBackToPosition(this, DraggingContext.getInstance().getCurrentPosition(), () -> new Point(TabWidget.this.getBounds().getCenterX() - 8, TabWidget.this.getBounds().getCenterY() - 8));
                        }
                    }
                };
            }
        }
        return null;
    }
}

