/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends Button {
    private static final ResourceLocation BUTTON_LOCATION = new ResourceLocation("roughlyenoughitems", "textures/gui/button.png");
    private static final ResourceLocation BUTTON_LOCATION_DARK = new ResourceLocation("roughlyenoughitems", "textures/gui/button_dark.png");
    private Rectangle bounds;
    private boolean enabled = true;
    private Component text;
    @Nullable
    private Integer tint;
    @Nullable
    private Consumer<Button> onClick;
    @Nullable
    private BiConsumer<PoseStack, Button> onRender;
    private boolean focusable = false;
    private boolean focused = false;
    @Nullable
    private @Nullable Function<Button, @Nullable Component[]> tooltipFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textColorFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textureIdFunction;

    public ButtonWidget(Rectangle rectangle, Component text) {
        this.bounds = new Rectangle(Objects.requireNonNull(rectangle));
        this.text = Objects.requireNonNull(text);
    }

    @Override
    public final boolean isFocused() {
        return this.focused;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public final OptionalInt getTint() {
        return OptionalInt.empty();
    }

    @Override
    public final void setTint(int tint) {
        this.tint = tint;
    }

    @Override
    public final void removeTint() {
        this.tint = null;
    }

    @Override
    public final Component getText() {
        return this.text;
    }

    @Override
    public final void setText(Component text) {
        this.text = text;
    }

    @Override
    @Nullable
    public final Consumer<Button> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Button> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<PoseStack, Button> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(BiConsumer<PoseStack, Button> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    @Override
    @Nullable
    public final Component[] getTooltip() {
        if (this.tooltipFunction == null) {
            return null;
        }
        return this.tooltipFunction.apply(this);
    }

    @Override
    public final void setTooltip(@Nullable @Nullable Function<Button, @Nullable Component[]> tooltip) {
        this.tooltipFunction = tooltip;
    }

    @Override
    public final void setTextColor(@Nullable BiFunction<Button, Point, Integer> textColorFunction) {
        this.textColorFunction = textColorFunction;
    }

    @Override
    public final void setTextureId(@Nullable BiFunction<Button, Point, Integer> textureIdFunction) {
        this.textureIdFunction = textureIdFunction;
    }

    @Override
    public final int getTextColor(Point mouse) {
        Integer apply;
        if (this.textColorFunction != null && (apply = this.textColorFunction.apply(this, mouse)) != null) {
            return apply;
        }
        if (!this.enabled) {
            return 0xA0A0A0;
        }
        if (this.isFocused(mouse.x, mouse.y)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.onRender != null) {
            this.onRender.accept(matrices, this);
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        this.renderBackground(matrices, x, y, width, height, this.getTextureId(new Point(mouseX, mouseY)));
        int color = 0xE0E0E0;
        if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.isFocused(mouseX, mouseY)) {
            color = 0xFFFFA0;
        }
        if (this.tint != null) {
            this.m_93179_(matrices, x + 1, y + 1, x + width - 1, y + height - 1, this.tint, this.tint);
        }
        ButtonWidget.m_93215_((PoseStack)matrices, (Font)this.font, (Component)this.getText(), (int)(x + width / 2), (int)(y + (height - 8) / 2), (int)color);
        Component[] tooltip = this.getTooltip();
        if (tooltip != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (this.focused) {
                Tooltip.create(new Point(x + width / 2, y + height / 2), tooltip).queue();
            }
        }
    }

    protected boolean isFocused(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    public boolean m_5755_(boolean boolean_1) {
        if (!this.enabled || !this.focusable) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    @Override
    public void onClick() {
        Consumer<Button> onClick = this.getOnClick();
        if (onClick != null) {
            onClick.accept(this);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY) && this.isEnabled() && button == 0) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (this.isEnabled() && this.focused) {
            if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
                return false;
            }
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    @Override
    public final int getTextureId(Point mouse) {
        Integer apply;
        if (this.textureIdFunction != null && (apply = this.textureIdFunction.apply(this, mouse)) != null) {
            return apply;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        if (this.containsMouse(mouse) || this.focused) {
            return 4;
        }
        return 1;
    }

    protected void renderBackground(PoseStack matrices, int x, int y, int width, int height, int textureOffset) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)(REIRuntime.getInstance().isDarkThemeEnabled() ? BUTTON_LOCATION_DARK : BUTTON_LOCATION));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        RenderSystem.m_69405_((int)770, (int)771);
        ButtonWidget.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)this.m_93252_(), (float)0.0f, (float)(textureOffset * 80), (int)8, (int)8, (int)512, (int)256);
        ButtonWidget.m_93143_((PoseStack)matrices, (int)(x + width - 8), (int)y, (int)this.m_93252_(), (float)248.0f, (float)(textureOffset * 80), (int)8, (int)8, (int)512, (int)256);
        ButtonWidget.m_93143_((PoseStack)matrices, (int)x, (int)(y + height - 8), (int)this.m_93252_(), (float)0.0f, (float)(textureOffset * 80 + 72), (int)8, (int)8, (int)512, (int)256);
        ButtonWidget.m_93143_((PoseStack)matrices, (int)(x + width - 8), (int)(y + height - 8), (int)this.m_93252_(), (float)248.0f, (float)(textureOffset * 80 + 72), (int)8, (int)8, (int)512, (int)256);
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)y, (int)(y + 8), (int)this.getZ(), (float)0.03125f, (float)0.96875f, (float)((float)(textureOffset * 80) / 512.0f), (float)((float)(textureOffset * 80 + 8) / 512.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)(y + height - 8), (int)(y + height), (int)this.getZ(), (float)0.03125f, (float)0.96875f, (float)((float)(textureOffset * 80 + 72) / 512.0f), (float)((float)(textureOffset * 80 + 80) / 512.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)x, (int)(x + 8), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)0.0f, (float)0.03125f, (float)((float)(textureOffset * 80 + 8) / 512.0f), (float)((float)(textureOffset * 80 + 72) / 512.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + width - 8), (int)(x + width), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)0.96875f, (float)1.0f, (float)((float)(textureOffset * 80 + 8) / 512.0f), (float)((float)(textureOffset * 80 + 72) / 512.0f));
        GuiComponent.m_93112_((Matrix4f)matrix, (int)(x + 8), (int)(x + width - 8), (int)(y + 8), (int)(y + height - 8), (int)this.getZ(), (float)0.03125f, (float)0.96875f, (float)((float)(textureOffset * 80 + 8) / 512.0f), (float)((float)(textureOffset * 80 + 72) / 512.0f));
    }
}

