/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.view;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ViewsImpl
implements Views {
    public static Map<DisplayCategory<?>, List<Display>> buildMapFor(ViewSearchBuilder builder) {
        LinkedHashSet<Display> set;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<CategoryIdentifier<?>> categories = builder.getCategories();
        List<EntryStack<?>> recipesFor = builder.getRecipesFor();
        List<EntryStack<?>> usagesFor = builder.getUsagesFor();
        DisplayRegistry displayRegistry = DisplayRegistry.getInstance();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Object categoryConfiguration : CategoryRegistry.getInstance()) {
            DisplayCategory displayCategory = categoryConfiguration.getCategory();
            if (CategoryRegistry.getInstance().isCategoryInvisible(displayCategory)) continue;
            CategoryIdentifier<?> categoryIdentifier = categoryConfiguration.getCategoryIdentifier();
            List<?> allRecipesFromCategory = displayRegistry.get(categoryIdentifier);
            set = Sets.newLinkedHashSet();
            if (categories.contains(categoryIdentifier)) {
                for (Display display2 : allRecipesFromCategory) {
                    if (!displayRegistry.isDisplayVisible(display2)) continue;
                    set.add(display2);
                }
                if (set.isEmpty()) continue;
                CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
                continue;
            }
            block2: for (Display display3 : allRecipesFromCategory) {
                if (!displayRegistry.isDisplayVisible(display3)) continue;
                if (!recipesFor.isEmpty()) {
                    block3: for (List list : display3.getOutputEntries()) {
                        for (EntryStack otherEntry : list) {
                            for (EntryStack<?> stack : recipesFor) {
                                if (!EntryStacks.equalsFuzzy(otherEntry, stack)) continue;
                                set.add(display3);
                                break block3;
                            }
                        }
                    }
                }
                if (usagesFor.isEmpty()) continue;
                for (List list : display3.getInputEntries()) {
                    for (EntryStack otherEntry : list) {
                        for (EntryStack<?> stack : usagesFor) {
                            if (!EntryStacks.equalsFuzzy(otherEntry, stack)) continue;
                            set.add(display3);
                            continue block2;
                        }
                    }
                }
            }
            for (EntryStack entryStack : usagesFor) {
                if (!ViewsImpl.isStackWorkStationOfCategory(categoryConfiguration, entryStack)) continue;
                set.addAll(CollectionUtils.filterToSet(allRecipesFromCategory, displayRegistry::isDisplayVisible));
                break;
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, displayCategory).addAll(set);
        }
        int generatorsCount = 0;
        for (Map.Entry entry : displayRegistry.getCategoryDisplayGenerators().entrySet()) {
            CategoryIdentifier categoryIdentifier = (CategoryIdentifier)entry.getKey();
            DisplayCategory category = CategoryRegistry.getInstance().get(categoryIdentifier).getCategory();
            if (CategoryRegistry.getInstance().isCategoryInvisible(category)) continue;
            set = new LinkedHashSet<Display>();
            generatorsCount += ((List)entry.getValue()).size();
            for (DynamicDisplayGenerator dynamicDisplayGenerator : (List)entry.getValue()) {
                ViewsImpl.generateLiveDisplays(displayRegistry, dynamicDisplayGenerator, builder, set::add);
            }
            if (set.isEmpty()) continue;
            CollectionUtils.getOrPutEmptyList(result, category).addAll(set);
        }
        Consumer<Display> displayConsumer = display -> CollectionUtils.getOrPutEmptyList(result, CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory()).add(display);
        for (DynamicDisplayGenerator<?> dynamicDisplayGenerator : displayRegistry.getGlobalDisplayGenerators()) {
            ++generatorsCount;
            ViewsImpl.generateLiveDisplays(displayRegistry, dynamicDisplayGenerator, builder, displayConsumer);
        }
        String string = String.format("Built Recipe View in %s for %d categories, %d recipes for, %d usages for and %d live recipe generators.", stopwatch.stop(), categories.size(), recipesFor.size(), usagesFor.size(), generatorsCount);
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            RoughlyEnoughItemsCore.LOGGER.info(string);
        } else {
            RoughlyEnoughItemsCore.LOGGER.trace(string);
        }
        return result;
    }

    private static <T extends Display> void generateLiveDisplays(DisplayRegistry displayRegistry, DynamicDisplayGenerator<T> generator, ViewSearchBuilder builder, Consumer<T> displayConsumer) {
        for (EntryStack<?> stack : builder.getRecipesFor()) {
            Optional<List<T>> recipeForDisplays = generator.getRecipeFor(stack);
            if (!recipeForDisplays.isPresent()) continue;
            for (Display display : recipeForDisplays.get()) {
                if (!displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        for (EntryStack<?> stack : builder.getUsagesFor()) {
            Optional<List<T>> usageForDisplays = generator.getUsageFor(stack);
            if (!usageForDisplays.isPresent()) continue;
            for (Display display : usageForDisplays.get()) {
                if (!displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        Optional<List<T>> displaysGenerated = generator.generate(builder);
        if (displaysGenerated.isPresent()) {
            for (Display display : displaysGenerated.get()) {
                if (!displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
    }

    @Override
    public Collection<EntryStack<?>> findCraftableEntriesByMaterials() {
        final AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
        HashSet craftables = new HashSet();
        for (final Map.Entry<CategoryIdentifier<?>, List<Display>> entry : DisplayRegistry.getInstance().getAll().entrySet()) {
            final MenuInfo<LocalPlayer, LocalPlayer> info = menu != null ? MenuInfoRegistry.getInstance().get(entry.getKey(), menu.getClass()) : null;
            class InfoContext
            implements MenuInfoContext<AbstractContainerMenu, LocalPlayer, Display> {
                private Display display;

                InfoContext() {
                }

                @Override
                public AbstractContainerMenu getMenu() {
                    return menu;
                }

                @Override
                public LocalPlayer getPlayerEntity() {
                    return Minecraft.m_91087_().f_91074_;
                }

                @Override
                public MenuInfo<AbstractContainerMenu, Display> getContainerInfo() {
                    return info;
                }

                @Override
                public CategoryIdentifier<Display> getCategoryIdentifier() {
                    return (CategoryIdentifier)entry.getKey();
                }

                @Override
                public Display getDisplay() {
                    return this.display;
                }
            }
            InfoContext context = new InfoContext();
            List<Display> displays = entry.getValue();
            Iterator<Display> iterator = displays.iterator();
            while (iterator.hasNext()) {
                Display display;
                context.display = display = iterator.next();
                Set<SlotAccessor> inputSlots = info != null ? info.getInputSlots(context) : Collections.emptySet();
                int slotsCraftable = 0;
                List<EntryIngredient> requiredInput = display.getRequiredEntries();
                block2: for (EntryIngredient slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    for (EntryStack slotPossible : slot) {
                        if (!CraftableFilter.INSTANCE.matches(slotPossible, inputSlots)) continue;
                        ++slotsCraftable;
                        continue block2;
                    }
                }
                if (slotsCraftable != display.getRequiredEntries().size()) continue;
                display.getOutputEntries().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> craftables));
            }
        }
        return craftables;
    }

    private static <T> boolean isStackWorkStationOfCategory(CategoryRegistry.CategoryConfiguration<?> category, EntryStack<T> stack) {
        for (EntryIngredient ingredient : category.getWorkstations()) {
            if (!EntryIngredients.testFuzzy(ingredient, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startReload() {
    }
}

