/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import me.shedaniel.rei.impl.common.entry.TypedEntryStack;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.TagContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractEntryStack<A>
implements EntryStack<A>,
Renderer {
    private static final Short2ObjectMap<Object> EMPTY_SETTINGS = Short2ObjectMaps.emptyMap();
    private Short2ObjectMap<Object> settings = null;
    @OnlyIn(value=Dist.CLIENT)
    private int blitOffset;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getZ() {
        return this.blitOffset;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setZ(int z) {
        this.blitOffset = z;
    }

    @Override
    public <T> EntryStack<A> setting(EntryStack.Settings<T> settings, T value) {
        short settingsId = settings.getId();
        if (this.settings == null) {
            this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
        } else {
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
                    return this;
                }
                Short2ObjectMap<Object> singletonSettings = this.settings;
                this.settings = new Short2ObjectOpenHashMap(2);
                this.settings.putAll(singletonSettings);
            }
            this.settings.put(settingsId, value);
        }
        return this;
    }

    @Override
    public <T> EntryStack<A> removeSetting(EntryStack.Settings<T> settings) {
        if (this.settings != null) {
            short settingsId = settings.getId();
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = null;
                }
            } else if (this.settings.remove(settingsId) != null && this.settings.isEmpty()) {
                this.settings = null;
            }
        }
        return this;
    }

    @Override
    public EntryStack<A> clearSettings() {
        this.settings = null;
        return this;
    }

    protected Short2ObjectMap<Object> getSettings() {
        return this.settings == null ? EMPTY_SETTINGS : this.settings;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier() {
        return this.getDefinition().getIdentifier(this, this.getValue());
    }

    @Override
    public boolean isEmpty() {
        return this.getDefinition().isEmpty(this, this.getValue());
    }

    @Override
    public EntryStack<A> copy() {
        return this.wrap(this.getDefinition().copy(this, this.getValue()), true);
    }

    @Override
    public EntryStack<A> rewrap() {
        return this.wrap(this.getValue(), true);
    }

    @Override
    public EntryStack<A> normalize() {
        return this.wrap(this.getDefinition().normalize(this, this.getValue()), false);
    }

    protected EntryStack<A> wrap(A value, boolean copySettings) {
        TypedEntryStack<Object> stack = new TypedEntryStack<Object>(this.getDefinition(), value);
        if (copySettings) {
            for (Short2ObjectMap.Entry entry : this.getSettings().short2ObjectEntrySet()) {
                stack.setting(EntryStack.Settings.getById(entry.getShortKey()), entry.getValue());
            }
        }
        return stack;
    }

    @Override
    public <T> T get(EntryStack.Settings<T> settings) {
        Object o;
        Object object = o = this.settings == null ? null : this.settings.get(settings.getId());
        if (o == null) {
            return settings.getDefaultValue();
        }
        return (T)o;
    }

    @Override
    public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        try {
            this.getRenderer().render(this, matrices, bounds, mouseX, mouseY, delta);
        }
        catch (Throwable throwable) {
            CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry");
            CrashReportUtils.renderer(report, this);
            throw CrashReportUtils.throwReport(report);
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(Point mouse, boolean appendModName) {
        try {
            ResourceLocation location;
            MutableObject tooltip = new MutableObject((Object)this.getRenderer().cast().getTooltip(this, mouse));
            if (tooltip.getValue() == null) {
                return null;
            }
            ((Tooltip)tooltip.getValue()).withContextStack(this);
            ((Tooltip)tooltip.getValue()).addAllTexts((Iterable<Component>)this.get((EntryStack.Settings)EntryStack.Settings.TOOLTIP_APPEND_EXTRA).apply(this));
            tooltip.setValue((Object)this.get((EntryStack.Settings)EntryStack.Settings.TOOLTIP_PROCESSOR).apply(this, (Tooltip)tooltip.getValue()));
            if (tooltip.getValue() == null) {
                return null;
            }
            if (appendModName && (location = this.getIdentifier()) != null) {
                ClientHelper.getInstance().appendModIdToTooltips((Tooltip)tooltip.getValue(), location.m_135827_());
            }
            return (Tooltip)tooltip.getValue();
        }
        catch (Throwable throwable) {
            CrashReport report = CrashReportUtils.essential(throwable, "Getting tooltips");
            CrashReportUtils.renderer(report, this);
            throw CrashReportUtils.throwReport(report);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Object object = o;
        if (!(object instanceof AbstractEntryStack)) {
            return false;
        }
        AbstractEntryStack that = (AbstractEntryStack)object;
        return EntryStacks.equalsExact(this, that);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(EntryStacks.hashExact(this));
    }

    @Override
    public Collection<ResourceLocation> getTagsFor() {
        TagContainer container = Platform.getEnvironment() == Env.CLIENT ? AbstractEntryStack.getClientTagContainer() : SerializationTags.m_13199_();
        return this.getDefinition().getTagsFor(container, this, this.getValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static TagContainer getClientTagContainer() {
        return Minecraft.m_91087_().m_91403_().m_105148_();
    }

    @Override
    public Component asFormattedText() {
        return this.getDefinition().asFormattedText(this, this.getValue());
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category) {
        EntryStack.super.fillCrashReport(report, category);
        category.m_128165_("Entry type", () -> String.valueOf(this.getType().getId()));
        category.m_128165_("Is empty", () -> String.valueOf(this.isEmpty()));
        category.m_128165_("Entry identifier", () -> String.valueOf(this.getIdentifier()));
        CrashReportCategory rendererCategory = report.m_127514_("Entry Renderer");
        try {
            this.getDefinition().fillCrashReport(report, rendererCategory, this);
        }
        catch (Throwable throwable) {
            rendererCategory.m_128162_("Filling Report", throwable);
        }
    }
}

