/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import java.util.IdentityHashMap;
import java.util.Map;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparatorRegistry;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class EntryComparatorRegistryImpl<T, S>
implements EntryComparatorRegistry<T, S> {
    private static final Logger LOGGER = LogManager.getLogger(EntryComparatorRegistryImpl.class);
    private final Map<S, EntryComparator<T>> comparators = new IdentityHashMap<S, EntryComparator<T>>();

    @Override
    public void register(EntryComparator<T> comparator, S entry) {
        EntryComparator<T> put = this.comparators.put(entry, comparator);
        if (put != null) {
            LOGGER.warn("[REI] Overriding " + put + "entry comparator with " + comparator + "for " + entry + "! This may result in unwanted comparisons!");
        }
    }

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void startReload() {
        this.comparators.clear();
    }

    public abstract S getEntry(T var1);

    public abstract EntryComparator<T> defaultComparator();

    @Override
    public long hashOf(ComparisonContext context, T stack) {
        EntryComparator<T> comparator = this.comparators.get(this.getEntry(stack));
        if (comparator != null) {
            return comparator.hash(context, stack);
        }
        return this.defaultComparator().hash(context, stack);
    }

    @Override
    public boolean containsComparator(S item) {
        return this.comparators.containsKey(item);
    }

    @Override
    public int comparatorSize() {
        return this.comparators.size();
    }
}

