/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class EntryRegistryImpl
implements EntryRegistry {
    private final List<EntryStack<?>> preFilteredList = Lists.newCopyOnWriteArrayList();
    private final List<EntryStack<?>> entries = Lists.newCopyOnWriteArrayList();
    @Nullable
    private List<HashedEntryStackWrapper> reloadingRegistry;
    private boolean reloading;
    private static final Comparator<ItemStack> STACK_COMPARATOR = (a, b) -> ItemStack.m_41728_((ItemStack)a, (ItemStack)b) ? 0 : 1;

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerEntries(this);
    }

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void startReload() {
        this.entries.clear();
        if (this.reloadingRegistry != null) {
            this.reloadingRegistry.clear();
        }
        this.reloadingRegistry = Lists.newArrayListWithCapacity((int)(Registry.f_122827_.m_6566_().size() + 100));
        this.preFilteredList.clear();
        this.reloading = true;
    }

    @Override
    public void endReload() {
        this.reloading = false;
        this.preFilteredList.clear();
        this.reloadingRegistry.removeIf(HashedEntryStackWrapper::isEmpty);
        this.entries.clear();
        this.entries.addAll(CollectionUtils.map(this.reloadingRegistry, HashedEntryStackWrapper::unwrap));
        this.reloadingRegistry = null;
        this.refilter();
    }

    @Override
    public int size() {
        return this.reloading ? this.reloadingRegistry.size() : this.entries.size();
    }

    @Override
    public Stream<EntryStack<?>> getEntryStacks() {
        return this.reloading ? this.reloadingRegistry.stream().map(HashedEntryStackWrapper::unwrap) : this.entries.stream();
    }

    @Override
    public List<EntryStack<?>> getPreFilteredList() {
        return Collections.unmodifiableList(this.preFilteredList);
    }

    @Override
    public void refilter() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        FilteringContextImpl context = new FilteringContextImpl(this.entries);
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        Stopwatch innerStopwatch = Stopwatch.createStarted();
        for (int i = rules.size() - 1; i >= 0; --i) {
            innerStopwatch.reset().start();
            FilteringRule<?> rule = rules.get(i);
            context.handleResult(rule.processFilteredStacks(context));
            RoughlyEnoughItemsCore.LOGGER.debug("Refiltered rule [%s] in %s.", (Object)FilteringRule.REGISTRY.m_7981_(rule).toString(), (Object)innerStopwatch.stop().toString());
        }
        Set<HashedEntryStackWrapper> hiddenStacks = context.stacks.get((Object)FilteringContextType.HIDDEN);
        if (hiddenStacks.isEmpty()) {
            this.preFilteredList.clear();
            this.preFilteredList.addAll(this.entries);
        } else {
            this.preFilteredList.clear();
            this.preFilteredList.addAll(this.entries.parallelStream().map(HashedEntryStackWrapper::new).filter(EntryRegistryImpl.not(hiddenStacks::contains)).map(HashedEntryStackWrapper::unwrap).collect(Collectors.toList()));
        }
        RoughlyEnoughItemsCore.LOGGER.debug("Refiltered %d entries with %d rules in %s.", (Object)(this.entries.size() - this.preFilteredList.size()), (Object)rules.size(), (Object)stopwatch.stop().toString());
    }

    private static <T> Predicate<T> not(Predicate<? super T> target) {
        Objects.requireNonNull(target);
        return target.negate();
    }

    @Override
    public List<ItemStack> appendStacksForItem(Item item) {
        NonNullList list = NonNullList.m_122779_();
        CreativeModeTab category = item.m_41471_();
        item.m_6787_((CreativeModeTab)MoreObjects.firstNonNull((Object)category, (Object)CreativeModeTab.f_40754_), list);
        if (list.isEmpty()) {
            return Collections.singletonList(item.m_7968_());
        }
        list.sort(STACK_COMPARATOR);
        return list;
    }

    @Override
    public void addEntryAfter(@Nullable EntryStack<?> afterEntry, EntryStack<?> stack) {
        if (this.reloading) {
            int index;
            int n = index = afterEntry != null ? this.reloadingRegistry.lastIndexOf(new HashedEntryStackWrapper(afterEntry)) : -1;
            if (index >= 0) {
                this.reloadingRegistry.add(index, new HashedEntryStackWrapper(stack));
            } else {
                this.reloadingRegistry.add(new HashedEntryStackWrapper(stack));
            }
        } else if (afterEntry != null) {
            int index = this.entries.lastIndexOf(afterEntry);
            this.entries.add(index, stack);
        } else {
            this.entries.add(stack);
        }
    }

    @Override
    public void addEntriesAfter(@Nullable EntryStack<?> afterEntry, Collection<? extends EntryStack<?>> stacks) {
        if (this.reloading) {
            int index;
            int n = index = afterEntry != null ? this.reloadingRegistry.lastIndexOf(new HashedEntryStackWrapper(afterEntry)) : -1;
            if (index >= 0) {
                this.reloadingRegistry.addAll(index, CollectionUtils.mapParallel(stacks, HashedEntryStackWrapper::new));
            } else {
                this.reloadingRegistry.addAll(CollectionUtils.mapParallel(stacks, HashedEntryStackWrapper::new));
            }
        } else if (afterEntry != null) {
            int index = this.entries.lastIndexOf(afterEntry);
            this.entries.addAll(index, stacks);
        } else {
            this.entries.addAll(stacks);
        }
    }

    @Override
    public boolean alreadyContain(EntryStack<?> stack) {
        if (this.reloading) {
            return this.reloadingRegistry.parallelStream().anyMatch(s -> EntryStacks.equalsExact(s.unwrap(), stack));
        }
        return this.entries.parallelStream().anyMatch(s -> EntryStacks.equalsExact(s, stack));
    }

    @Override
    public boolean removeEntry(EntryStack<?> stack) {
        if (this.reloading) {
            return this.reloadingRegistry.remove(new HashedEntryStackWrapper(stack));
        }
        return this.entries.remove(stack);
    }

    @Override
    public boolean removeEntryIf(Predicate<? extends EntryStack<?>> predicate) {
        if (this.reloading) {
            return this.reloadingRegistry.removeIf(wrapper -> predicate.test(wrapper.unwrap()));
        }
        return this.entries.removeIf(predicate);
    }

    @Override
    public boolean removeEntryExactHashIf(LongPredicate predicate) {
        if (this.reloading) {
            return this.reloadingRegistry.removeIf(wrapper -> predicate.test(wrapper.hashExact()));
        }
        return this.entries.removeIf(stack -> predicate.test(EntryStacks.hashExact(stack)));
    }

    @Override
    public boolean removeEntryFuzzyHashIf(LongPredicate predicate) {
        if (this.reloading) {
            return this.reloadingRegistry.removeIf(wrapper -> predicate.test(EntryStacks.hashFuzzy(wrapper.unwrap())));
        }
        return this.entries.removeIf(stack -> predicate.test(EntryStacks.hashFuzzy(stack)));
    }
}

