/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class InputSlotCrafter<T extends AbstractContainerMenu, C extends Container, D extends Display>
implements MenuInfoContext<T, ServerPlayer, D> {
    protected CategoryIdentifier<D> category;
    protected T container;
    protected D display;
    protected MenuInfo<T, D> menuInfo;
    private Iterable<SlotAccessor> inputStacks;
    private Iterable<SlotAccessor> inventoryStacks;
    private ServerPlayer player;

    private InputSlotCrafter(CategoryIdentifier<D> category, T container, CompoundTag display, MenuInfo<T, D> menuInfo) {
        this.category = category;
        this.container = container;
        this.menuInfo = menuInfo;
        this.display = menuInfo.read(this, display);
    }

    public static <T extends AbstractContainerMenu, C extends Container, D extends Display> InputSlotCrafter<T, C, D> start(CategoryIdentifier<D> category, T menu, ServerPlayer player, CompoundTag display, boolean hasShift) {
        MenuInfo<?, D> menuInfo = Objects.requireNonNull(MenuInfoRegistry.getInstance().get(category, menu.getClass()), "Container Info does not exist on the server!");
        InputSlotCrafter<T, C, D> crafter = new InputSlotCrafter<T, C, D>(category, menu, display, menuInfo);
        crafter.fillInputSlots(player, hasShift);
        return crafter;
    }

    private void fillInputSlots(ServerPlayer player, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.menuInfo.getInventorySlots(this);
        this.inputStacks = this.menuInfo.getInputSlots(this);
        this.cleanInputs();
        RecipeFinder recipeFinder = new RecipeFinder();
        this.menuInfo.getRecipeFinderPopulator().populate(this, recipeFinder);
        NonNullList ingredients = NonNullList.m_122779_();
        for (List<ItemStack> itemStacks : this.menuInfo.getInputs(this)) {
            ingredients.add((Object)CollectionUtils.toIngredient(itemStacks));
        }
        if (!recipeFinder.findRecipe((NonNullList<Ingredient>)ingredients, null)) {
            this.cleanInputs();
            this.menuInfo.markDirty(this);
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, (NonNullList<Ingredient>)ingredients, hasShift);
        this.menuInfo.markDirty(this);
    }

    public void alignRecipeToGrid(Iterable<SlotAccessor> inputStacks, Iterator<Integer> recipeItemIds, int craftsAmount) {
        for (SlotAccessor inputStack : inputStacks) {
            if (!recipeItemIds.hasNext()) {
                return;
            }
            this.acceptAlignedInput(recipeItemIds.next(), inputStack, craftsAmount);
        }
    }

    public void acceptAlignedInput(Integer recipeItemId, SlotAccessor inputStack, int craftsAmount) {
        ItemStack toBeTakenStack = RecipeFinder.getStackFromId(recipeItemId);
        if (!toBeTakenStack.m_41619_()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(inputStack, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(SlotAccessor slot, ItemStack toBeTakenStack) {
        ItemStack takenStack;
        SlotAccessor takenSlot = this.takeInventoryStack(toBeTakenStack);
        if (takenSlot != null && !(takenStack = takenSlot.getItemStack().m_41777_()).m_41619_()) {
            if (takenStack.m_41613_() > 1) {
                takenSlot.takeStack(1);
            } else {
                takenSlot.setItemStack(ItemStack.f_41583_);
            }
            takenStack.m_41764_(1);
            if (slot.getItemStack().m_41619_()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().m_41769_(1);
            }
        }
    }

    protected void fillInputSlots(RecipeFinder recipeFinder, NonNullList<Ingredient> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        IntArrayList recipeItemIds = new IntArrayList();
        int amountToFill = hasShift ? recipeCrafts : 1;
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            IntListIterator intListIterator = recipeItemIds.iterator();
            while (intListIterator.hasNext()) {
                int itemId = (Integer)intListIterator.next();
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId(itemId).m_41741_());
            }
            if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, finalCraftsAmount)) {
                this.cleanInputs();
                this.alignRecipeToGrid(this.inputStacks, (Iterator<Integer>)recipeItemIds.iterator(), finalCraftsAmount);
            }
        }
    }

    protected void cleanInputs() {
        this.menuInfo.getInputCleanHandler().clean(this);
    }

    @Nullable
    public SlotAccessor takeInventoryStack(ItemStack itemStack) {
        for (SlotAccessor inventoryStack : this.inventoryStacks) {
            ItemStack itemStack1 = inventoryStack.getItemStack();
            if (itemStack1.m_41619_() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.m_41768_() || itemStack1.m_41793_() || itemStack1.m_41788_()) continue;
            return inventoryStack;
        }
        return null;
    }

    private static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    @Override
    public T getMenu() {
        return this.container;
    }

    @Override
    public ServerPlayer getPlayerEntity() {
        return this.player;
    }

    @Override
    public MenuInfo<T, D> getContainerInfo() {
        return this.menuInfo;
    }

    @Override
    public D getDisplay() {
        return this.display;
    }

    @Override
    public CategoryIdentifier<D> getCategoryIdentifier() {
        return this.category;
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

