/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class MenuInfoRegistryImpl
implements MenuInfoRegistry {
    private final Map<CategoryIdentifier<?>, Map<Class<? extends AbstractContainerMenu>, List<MenuInfoProvider<?, ?>>>> map = Maps.newLinkedHashMap();
    private final Map<Predicate<CategoryIdentifier<?>>, List<MenuInfoProvider<?, ?>>> mapGeneric = Maps.newLinkedHashMap();

    @Override
    public <C extends AbstractContainerMenu, D extends Display> void register(CategoryIdentifier<D> category, Class<C> menuClass, MenuInfoProvider<C, D> menuInfo) {
        this.map.computeIfAbsent(category, id -> Maps.newLinkedHashMap()).computeIfAbsent(menuClass, c -> Lists.newArrayList()).add(menuInfo);
    }

    @Override
    public <D extends Display> void registerGeneric(Predicate<CategoryIdentifier<?>> categoryPredicate, MenuInfoProvider<?, D> menuInfo) {
        this.mapGeneric.computeIfAbsent(categoryPredicate, id -> Lists.newArrayList()).add(menuInfo);
    }

    @Nullable
    public <T extends AbstractContainerMenu, D extends Display> MenuInfo<T, D> get(CategoryIdentifier<D> category, Class<T> menuClass) {
        Map<Class<AbstractContainerMenu>, List<MenuInfoProvider<?, ?>>> infoMap = this.map.get(category);
        if (infoMap != null && !infoMap.isEmpty()) {
            if (infoMap.containsKey(menuClass)) {
                for (MenuInfoProvider menuInfoProvider : infoMap.get(menuClass)) {
                    Optional<MenuInfo<T, D>> info = menuInfoProvider.provide(category, menuClass);
                    if (!info.isPresent()) continue;
                    return info.get();
                }
            }
            for (Map.Entry entry : infoMap.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(menuClass)) continue;
                for (MenuInfoProvider provider : (List)entry.getValue()) {
                    Optional<MenuInfo<T, D>> info = provider.provide(category, menuClass);
                    if (!info.isPresent()) continue;
                    return info.get();
                }
            }
        }
        for (Map.Entry<Predicate<CategoryIdentifier<?>>, List<MenuInfoProvider<?, ?>>> entry : this.mapGeneric.entrySet()) {
            Optional<MenuInfo<?, ?>> info;
            List<MenuInfoProvider<?, ?>> infoList;
            if (!entry.getKey().test(category) || entry.getValue().isEmpty() || (infoList = entry.getValue()).isEmpty() || !(info = infoList.get(0).provide(category, menuClass)).isPresent()) continue;
            return info.get();
        }
        return null;
    }

    @Override
    public int infoSize() {
        return this.map.size() + this.mapGeneric.size();
    }

    @Override
    public void startReload() {
        this.map.clear();
        this.mapGeneric.clear();
    }

    @Override
    public void acceptPlugin(REIServerPlugin plugin) {
        plugin.registerMenuInfo(this);
    }
}

