/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.transfer;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.transfer.info.simple.SimplePlayerInventoryMenuInfo;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.transfer.JEIRecipeTransferData;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class JEITransferMenuInfo<T extends AbstractContainerMenu>
implements SimplePlayerInventoryMenuInfo<T, Display> {
    public static final String KEY = "REI-JEI-Transfer-Data";
    @Nullable
    protected Supplier<JEIRecipeTransferData<T>> data;
    @Nullable
    protected T menu;

    public JEIRecipeTransferData<T> getData(MenuSerializationContext<T, ?, Display> context) {
        this.menu = context.getMenu();
        JEIRecipeTransferData<T> transferData = this.data.get();
        this.menu = null;
        return transferData;
    }

    @Override
    public Iterable<SlotAccessor> getInventorySlots(MenuInfoContext<T, ?, Display> context) {
        return CollectionUtils.map(this.getData(context).getInventorySlots(), SlotAccessor::fromSlot);
    }

    @Override
    public Iterable<SlotAccessor> getInputSlots(MenuInfoContext<T, ?, Display> context) {
        return CollectionUtils.map(this.getData(context).getRecipeSlots(), SlotAccessor::fromSlot);
    }

    @Override
    public CompoundTag save(MenuSerializationContext<T, ?, Display> context, Display display) {
        CompoundTag tag = SimplePlayerInventoryMenuInfo.super.save(context, display);
        tag.m_128365_(KEY, (Tag)this.getData(context).save(new CompoundTag()));
        return tag;
    }

    @Override
    public Display read(MenuSerializationContext<T, ?, Display> context, CompoundTag tag) {
        this.data = Suppliers.ofInstance(JEIRecipeTransferData.read(context.getMenu(), tag.m_128469_(KEY)));
        return SimplePlayerInventoryMenuInfo.super.read(context, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client<T extends AbstractContainerMenu>
    extends JEITransferMenuInfo<T> {
        private final IRecipeTransferInfo<T> info;

        public Client(Function<T, JEIRecipeTransferData<T>> data, IRecipeTransferInfo<T> info) {
            this.info = info;
            this.data = Suppliers.memoize(() -> (JEIRecipeTransferData)data.apply(Objects.requireNonNull(this.menu)));
        }

        @Override
        public void validate(MenuInfoContext<T, ?, Display> context) throws MenuTransferException {
            if (!this.info.canHandle(context.getMenu())) {
                throw MenuTransferException.createNotApplicable();
            }
        }
    }
}

