/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.unwrap;

import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class JEIIngredientHelper<T>
implements IIngredientHelper<T> {
    private final EntryDefinition<T> definition;

    public JEIIngredientHelper(EntryDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    @Nullable
    public T getMatch(Iterable<T> ingredients, T ingredientToMatch, UidContext context) {
        ComparisonContext comparisonContext = JEIPluginDetector.wrapContext(context);
        T value = JEIPluginDetector.wrap(this.definition, ingredientToMatch).getValue();
        return (T)CollectionUtils.findFirstOrNull(ingredients, t -> this.definition.equals(JEIPluginDetector.wrap(this.definition, t).getValue(), value, comparisonContext));
    }

    @Override
    public String getDisplayName(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.wrap(this.definition, ingredient);
        return this.definition.asFormattedText(entry, entry.getValue()).getString();
    }

    @Override
    public String getUniqueId(T ingredient, UidContext context) {
        ComparisonContext comparisonContext = JEIPluginDetector.wrapContext(context);
        EntryStack<T> entry = JEIPluginDetector.wrap(this.definition, ingredient);
        return String.valueOf(EntryStacks.hash(entry, comparisonContext));
    }

    @Override
    public String getModId(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.wrap(this.definition, ingredient);
        ResourceLocation location = this.definition.getIdentifier(entry, entry.getValue());
        return location == null ? "minecraft" : location.m_135827_();
    }

    @Override
    public String getResourceId(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.wrap(this.definition, ingredient);
        ResourceLocation location = this.definition.getIdentifier(entry, entry.getValue());
        return location == null ? "minecraft:unknown" : location.toString();
    }

    @Override
    public T copyIngredient(T ingredient) {
        EntryStack<T> entry = JEIPluginDetector.wrap(this.definition, ingredient);
        return this.definition.copy(entry, entry.getValue());
    }

    @Override
    public String getErrorInfo(@Nullable T ingredient) {
        try {
            return this.getResourceId(ingredient);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.getClass().getName() + ": " + throwable.getLocalizedMessage();
        }
    }
}

