/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import dev.architectury.fluid.FluidStack;
import dev.architectury.utils.value.Value;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroup;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroupFluid;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroupItem;
import me.shedaniel.rei.jeicompat.wrap.JEIEntryDefinition;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JEIRecipeLayout<T>
implements IRecipeLayout {
    private final Map<EntryDefinition<?>, IGuiIngredientGroup<?>> groups = new HashMap();
    public final Value<IDrawable> background;

    public JEIRecipeLayout(Value<IDrawable> background) {
        this.background = background;
    }

    @Override
    @NotNull
    public IGuiItemStackGroup getItemStacks() {
        return (IGuiItemStackGroup)this.getIngredientsGroup(VanillaTypes.ITEM);
    }

    @Override
    @NotNull
    public IGuiFluidStackGroup getFluidStacks() {
        return (IGuiFluidStackGroup)this.getIngredientsGroup(VanillaTypes.FLUID);
    }

    @Override
    @NotNull
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(@NotNull IIngredientType<T> ingredientType) {
        return this.groups.computeIfAbsent(JEIPluginDetector.wrapEntryDefinition(ingredientType), type -> {
            if (Objects.equals(ingredientType.getIngredientClass(), ItemStack.class)) {
                return new JEIGuiIngredientGroupItem(ingredientType.cast(), this.background);
            }
            if (Objects.equals(ingredientType.getIngredientClass(), net.minecraftforge.fluids.FluidStack.class)) {
                return new JEIGuiIngredientGroupFluid(ingredientType.cast(), this.background);
            }
            return new JEIGuiIngredientGroup(ingredientType, this.background);
        });
    }

    @Override
    @Nullable
    public IFocus<?> getFocus() {
        DisplayScreen screen = (DisplayScreen)Minecraft.m_91087_().f_91080_;
        List<EntryStack<?>> notice = screen.getIngredientsToNotice();
        if (!notice.isEmpty()) {
            return new JEIFocus(IFocus.Mode.INPUT, JEIPluginDetector.unwrap(notice.get(0).cast())).wrap();
        }
        notice = screen.getResultsToNotice();
        if (!notice.isEmpty()) {
            return new JEIFocus(IFocus.Mode.OUTPUT, JEIPluginDetector.unwrap(notice.get(0).cast())).wrap();
        }
        return null;
    }

    @Override
    @Nullable
    public <V> IFocus<V> getFocus(@NotNull IIngredientType<V> ingredientType) {
        return JEIFocus.cast(this.getFocus(), ingredientType);
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    public void setShapeless() {
        throw JEIPluginDetector.TODO();
    }

    public Map<EntryDefinition<?>, IGuiIngredientGroup<?>> getGroups() {
        return this.groups;
    }

    public void addTo(List<Widget> widgets, Rectangle bounds) {
        for (Map.Entry<EntryDefinition<?>, IGuiIngredientGroup<?>> groupEntry : this.getGroups().entrySet()) {
            JEIGuiIngredientGroup group = (JEIGuiIngredientGroup)groupEntry.getValue();
            Int2ObjectMap<JEIGuiIngredientGroup.SlotWrapper> guiIngredients = group.getGuiIngredients();
            IntArrayList integers = new IntArrayList((IntCollection)guiIngredients.keySet());
            integers.sort(Comparator.naturalOrder());
            IntListIterator intListIterator = integers.iterator();
            while (intListIterator.hasNext()) {
                int integer = (Integer)intListIterator.next();
                JEIGuiIngredientGroup.SlotWrapper wrapper = (JEIGuiIngredientGroup.SlotWrapper)guiIngredients.get(integer);
                wrapper.slot.getBounds().translate(bounds.x + 4, bounds.y + 4);
                wrapper.slot.highlightEnabled(!wrapper.isEmpty());
                if (wrapper.background != null) {
                    widgets.add(Widgets.wrapRenderer(wrapper.slot.getInnerBounds().clone(), JEIPluginDetector.wrapDrawable(wrapper.background)));
                }
                widgets.add(Widgets.withTranslate(wrapper.slot, 0.0, 0.0, 10.0));
                if (wrapper.renderer != null) {
                    JEIEntryDefinition.Renderer renderer = new JEIEntryDefinition.Renderer(wrapper.renderer);
                    for (EntryStack<?> entry : wrapper.slot.getEntries()) {
                        ClientEntryStacks.setRenderer(entry, renderer);
                    }
                } else if (wrapper.fluidCapacity == wrapper.fluidCapacity) {
                    for (EntryStack entryStack : wrapper.slot.getEntries()) {
                        if (entryStack.getType() != VanillaEntryTypes.FLUID) continue;
                        ClientEntryStacks.setFluidRenderRatio(entryStack.cast(), (float)((FluidStack)entryStack.cast().getValue()).getAmount() / wrapper.fluidCapacity);
                    }
                }
                if (wrapper.overlay != null) {
                    widgets.add(Widgets.withTranslate(Widgets.wrapRenderer(wrapper.slot.getInnerBounds().clone(), JEIPluginDetector.wrapDrawable(wrapper.overlay)), 0.0, 251.0, 0.0));
                }
                List tooltipCallbacks = group.tooltipCallbacks;
                for (EntryStack<?> entry : wrapper.slot.getEntries()) {
                    ClientEntryStacks.setTooltipProcessor(entry, (stack, tooltip) -> {
                        Object ingredient = null;
                        for (ITooltipCallback callback : tooltipCallbacks) {
                            if (ingredient == null) {
                                ingredient = JEIPluginDetector.unwrap(stack);
                            }
                            callback.onTooltip(integer, wrapper.isInput(), ingredient, tooltip.getText());
                        }
                        return tooltip;
                    });
                }
            }
        }
    }
}

