/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientManager;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIVanillaRecipeFactory;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum JEIRecipeRegistration implements IRecipeRegistration
{
    INSTANCE;


    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IIngredientManager getIngredientManager() {
        return JEIIngredientManager.INSTANCE;
    }

    @Override
    @NotNull
    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return JEIVanillaRecipeFactory.INSTANCE;
    }

    @Override
    public void addRecipes(@NotNull Collection<?> recipes, @NotNull ResourceLocation categoryId) {
        CategoryRegistry.CategoryConfiguration config = CategoryRegistry.getInstance().get(CategoryIdentifier.of(categoryId));
        DisplayCategory category = config.getCategory();
        for (Object recipe : recipes) {
            DisplayRegistry.getInstance().add(recipe);
        }
    }

    @Override
    public <T> void addIngredientInfo(@NotNull T ingredient, @NotNull IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        EntryStack<T> stack = JEIPluginDetector.wrap(ingredientType, ingredient);
        BuiltinClientPlugin.getInstance().registerInformation(stack, stack.asFormattedText(), components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }

    @Override
    public <T> void addIngredientInfo(@NotNull List<T> ingredients, @NotNull IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        EntryIngredient ingredient = JEIPluginDetector.wrapList(ingredientType, ingredients);
        BuiltinClientPlugin.getInstance().registerInformation(ingredient, (Component)ImmutableTextComponent.EMPTY, components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }
}

