/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.utils.value.Value;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.transfer.JEIRecipeTransferData;
import me.shedaniel.rei.jeicompat.transfer.JEITransferMenuInfo;
import me.shedaniel.rei.jeicompat.wrap.JEIGuiHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferError;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferHandlerHelper;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappingRecipeLayout;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class JEIRecipeTransferRegistration
implements IRecipeTransferRegistration {
    private final Consumer<Runnable> post;

    public JEIRecipeTransferRegistration(Consumer<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return JEIRecipeTransferHandlerHelper.INSTANCE;
    }

    @Override
    public <C extends AbstractContainerMenu> void addRecipeTransferHandler(final Class<C> containerClass, final ResourceLocation recipeCategoryUid, final int recipeSlotStart, final int recipeSlotCount, final int inventorySlotStart, final int inventorySlotCount) {
        this.addRecipeTransferHandler(new IRecipeTransferInfo<C>(){

            @Override
            public Class<C> getContainerClass() {
                return containerClass;
            }

            @Override
            public ResourceLocation getRecipeCategoryUid() {
                return recipeCategoryUid;
            }

            @Override
            public boolean canHandle(C container) {
                return this.getContainerClass().isInstance(container);
            }

            @Override
            public List<Slot> getRecipeSlots(C container) {
                return IntStream.range(recipeSlotStart, recipeSlotStart + recipeSlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }

            @Override
            public List<Slot> getInventorySlots(C container) {
                return IntStream.range(inventorySlotStart, inventorySlotStart + inventorySlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }
        });
    }

    @Override
    public <C extends AbstractContainerMenu> void addRecipeTransferHandler(IRecipeTransferInfo<C> info) {
        this.post.accept(() -> MenuInfoRegistry.getInstance().register(CategoryIdentifier.of(info.getRecipeCategoryUid()), info.getContainerClass(), (categoryId, menuClass) -> Optional.of(new JEITransferMenuInfo.Client<AbstractContainerMenu>(menu -> new JEIRecipeTransferData<AbstractContainerMenu>(info, (AbstractContainerMenu)menu), info))));
    }

    @Override
    public void addRecipeTransferHandler(IRecipeTransferHandler<?> recipeTransferHandler, ResourceLocation recipeCategoryUid) {
        TransferHandlerRegistry.getInstance().register(context -> {
            if (recipeTransferHandler.getContainerClass().isInstance(context.getMenu())) {
                Display display = context.getDisplay();
                if (recipeCategoryUid == null || display.getCategoryIdentifier().getIdentifier().equals((Object)recipeCategoryUid)) {
                    IRecipeTransferError error;
                    JEIRecipeLayout layout;
                    Value<IDrawable> background = new Value<IDrawable>(){

                        public void accept(IDrawable iDrawable) {
                        }

                        public IDrawable get() {
                            return JEIGuiHelper.INSTANCE.createBlankDrawable(0, 0);
                        }
                    };
                    if (display instanceof JEIWrappedDisplay) {
                        layout = ((JEIWrappedDisplay)display).getBackingCategory().createLayout((JEIWrappedDisplay)display, background);
                    } else {
                        DisplayCategory<?> category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory();
                        layout = new JEIWrappingRecipeLayout(category, background);
                        List<Widget> widgets = category.setupDisplay(display, new Rectangle(0, 0, category.getDisplayWidth(display), category.getDisplayHeight()));
                        this.addToLayout(layout, widgets);
                    }
                    if (context.isActuallyCrafting()) {
                        context.getMinecraft().m_91152_(context.getContainerScreen());
                    }
                    if ((error = recipeTransferHandler.transferRecipe(context.getMenu(), JEIPluginDetector.wrapRecipe(context.getDisplay()), layout, (Player)context.getMinecraft().f_91074_, Screen.m_96638_(), context.isActuallyCrafting())) == null) {
                        return TransferHandler.Result.createSuccessful();
                    }
                    if (error instanceof JEIRecipeTransferError) {
                        IntArrayList redSlots = ((JEIRecipeTransferError)error).getRedSlots();
                        if (redSlots == null) {
                            redSlots = new IntArrayList();
                        }
                        return TransferHandler.Result.createFailed(((JEIRecipeTransferError)error).getText(), (IntList)redSlots);
                    }
                }
            }
            return TransferHandler.Result.createNotApplicable();
        });
    }

    private void addToLayout(IRecipeLayout layout, List<Widget> entries) {
        HashMap<Boolean, List> groups = new HashMap<Boolean, List>();
        for (Widget widget : entries) {
            if (!(widget instanceof me.shedaniel.rei.api.client.gui.widgets.Slot)) continue;
            HashMultimap group = HashMultimap.create();
            List<EntryStack<?>> ingredient = ((me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getEntries();
            for (EntryStack<?> stack : ingredient) {
                group.put(stack.getType(), stack);
            }
            groups.computeIfAbsent(((me.shedaniel.rei.api.client.gui.widgets.Slot)widget).getNoticeMark() != 2, $ -> new ArrayList()).add(group);
        }
        for (Map.Entry entry : groups.entrySet()) {
            ((List)entry.getValue()).stream().map(Multimap::keys).flatMap(Collection::stream).distinct().forEach(type -> {
                IGuiIngredientGroup group = layout.getIngredientsGroup(type.getDefinition()::getValueType);
                int[] i = new int[]{this.getNextId(group.getGuiIngredients().keySet())};
                ((List)entry.getValue()).stream().map(map -> map.get(type)).filter(collection -> !collection.isEmpty()).forEach(stacks -> {
                    group.set(i[0], CollectionUtils.map(stacks, JEIPluginDetector::unwrap));
                    group.init(i[0], (Boolean)entry.getKey(), 0, 0);
                    i[0] = i[0] + 1;
                });
            });
        }
    }

    private int getNextId(Set<Integer> keys) {
        int i = 0;
        while (keys.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public void addUniversalRecipeTransferHandler(IRecipeTransferHandler<?> recipeTransferHandler) {
        this.addRecipeTransferHandler(recipeTransferHandler, null);
    }
}

