/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIBasedRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.LazyLoadedValue;
import org.jetbrains.annotations.Nullable;

public class JEIWrappedCategory<T>
implements DisplayCategory<JEIWrappedDisplay<T>> {
    private final IRecipeCategory<T> backingCategory;
    private final LazyLoadedValue<IDrawable> background;
    private final CategoryIdentifier<? extends JEIWrappedDisplay<T>> identifier;

    public JEIWrappedCategory(IRecipeCategory<T> backingCategory) {
        this.backingCategory = backingCategory;
        this.background = new LazyLoadedValue(backingCategory::getBackground);
        this.identifier = CategoryIdentifier.of(backingCategory.getUid());
    }

    public Class<? extends T> getRecipeClass() {
        return this.backingCategory.getRecipeClass();
    }

    public boolean handlesRecipe(T recipe) {
        return this.backingCategory.isHandled(recipe);
    }

    @Override
    public Renderer getIcon() {
        IDrawable icon = this.backingCategory.getIcon();
        if (icon != null) {
            return JEIPluginDetector.wrapDrawable(icon);
        }
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCategoryIdentifier()).getWorkstations();
        if (!workstations.isEmpty()) {
            return Widgets.createSlot(new Point(0, 0)).entries(workstations.get(0)).disableBackground().disableHighlight().disableTooltips();
        }
        FormattedCharSequence title = this.getTitle().m_7532_();
        final FormattedCharSequence titleTrimmed = sink -> title.m_13731_((index, style, codepoint) -> {
            if (index == 0 || index == 1) {
                sink.m_6411_(index, style, codepoint);
                return true;
            }
            return false;
        });
        return new Renderer(){

            @Override
            public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                Font font = Minecraft.m_91087_().f_91062_;
                font.m_92744_(matrices, titleTrimmed, (float)bounds.getCenterX() - (float)font.m_92724_(titleTrimmed) / 2.0f, (float)bounds.getCenterY() - 4.5f, 0xFFFFFF);
            }

            @Override
            public int getZ() {
                return 0;
            }

            @Override
            public void setZ(int z) {
            }
        };
    }

    @Override
    public Component getTitle() {
        return this.backingCategory.getTitle();
    }

    @Override
    public int getDisplayWidth(JEIWrappedDisplay<T> display) {
        return ((IDrawable)this.background.m_13971_()).getWidth() + 8;
    }

    @Override
    public CategoryIdentifier<? extends JEIWrappedDisplay<T>> getCategoryIdentifier() {
        return this.identifier;
    }

    @Override
    public int getDisplayHeight() {
        return ((IDrawable)this.background.m_13971_()).getHeight() + 8;
    }

    public IRecipeCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    public JEIRecipeLayout<T> createLayout(JEIWrappedDisplay<T> display, Value<IDrawable> background) {
        JEIBasedRecipeLayout<T> layout = new JEIBasedRecipeLayout<T>(this, display, background);
        this.backingCategory.setRecipe(layout, display.getBackingRecipe(), display.getIngredients());
        return layout;
    }

    @Override
    public List<Widget> setupDisplay(final JEIWrappedDisplay<T> display, final Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add(Widgets.createRecipeBase(bounds));
        final IDrawable[] background = new IDrawable[]{(IDrawable)this.background.m_13971_()};
        JEIRecipeLayout<T> layout = this.createLayout(display, new Value<IDrawable>(){

            public void accept(IDrawable iDrawable) {
                background[0] = iDrawable;
            }

            public IDrawable get() {
                return background[0];
            }
        });
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> background[0].draw(matrices, bounds.x + 4, bounds.y + 4)));
        widgets.add(new Widget(){

            public void m_6305_(PoseStack arg, int i, int j, float f) {
                Tooltip tooltip;
                arg.m_85836_();
                arg.m_85837_((double)(bounds.x + 4), (double)(bounds.y + 4), (double)this.getZ());
                JEIWrappedCategory.this.backingCategory.draw(display.getBackingRecipe(), arg, i, j);
                arg.m_85849_();
                Point mouse = PointHelper.ofMouse();
                if (this.containsMouse(mouse) && (tooltip = this.getTooltip(mouse)) != null) {
                    tooltip.queue();
                }
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point mouse) {
                List<Component> strings = JEIWrappedCategory.this.backingCategory.getTooltipStrings(display.getBackingRecipe(), mouse.x - bounds.x, mouse.y - bounds.y);
                if (strings.isEmpty()) {
                    return null;
                }
                return Tooltip.create(mouse, strings);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return Collections.emptyList();
            }

            public boolean m_6375_(double d, double e, int i) {
                return JEIWrappedCategory.this.backingCategory.handleClick(display.getBackingRecipe(), d - (double)bounds.x, e - (double)bounds.y, i) || super.m_6375_(d, e, i);
            }
        });
        layout.addTo(widgets, bounds);
        return widgets;
    }
}

