/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCategoryHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        Display display = context.getDisplay();
        AbstractContainerScreen<?> containerScreen = context.getContainerScreen();
        if (containerScreen == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        AbstractContainerMenu menu = context.getMenu();
        MenuInfo<AbstractContainerMenu, Display> menuInfo = MenuInfoRegistry.getInstance().get(display.getCategoryIdentifier(), menu.getClass());
        if (menuInfo == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        MenuInfoContext<AbstractContainerMenu, Player, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, menuInfo, display);
        try {
            menuInfo.validate(menuInfoContext);
        }
        catch (MenuTransferException e) {
            if (e.isApplicable()) {
                return TransferHandler.Result.createFailed(e.getError());
            }
            return TransferHandler.Result.createNotApplicable();
        }
        List<List<ItemStack>> input = menuInfo.getInputs(menuInfoContext);
        IntList intList = this.hasItems(menu, menuInfo, display, input);
        if (!intList.isEmpty()) {
            return TransferHandler.Result.createFailed((Component)new TranslatableComponent("error.rei.not.enough.materials"), intList);
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((Component)new TranslatableComponent("error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().m_91152_(containerScreen);
        AbstractContainerScreen<?> abstractContainerScreen = containerScreen;
        if (abstractContainerScreen instanceof RecipeUpdateListener) {
            RecipeUpdateListener listener = (RecipeUpdateListener)abstractContainerScreen;
            listener.m_5564_().f_100269_.m_100140_();
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130085_(display.getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(Screen.m_96638_());
        buf.m_130079_(menuInfo.save(menuInfoContext, display));
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, (FriendlyByteBuf)buf);
        return TransferHandler.Result.createSuccessful();
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    private static MenuInfoContext<AbstractContainerMenu, Player, Display> ofContext(final AbstractContainerMenu menu, final MenuInfo<AbstractContainerMenu, Display> info, final Display display) {
        return new MenuInfoContext<AbstractContainerMenu, Player, Display>(){

            @Override
            public AbstractContainerMenu getMenu() {
                return menu;
            }

            @Override
            public Player getPlayerEntity() {
                return Minecraft.m_91087_().f_91074_;
            }

            @Override
            public MenuInfo<AbstractContainerMenu, Display> getContainerInfo() {
                return info;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return display.getCategoryIdentifier();
            }

            @Override
            public Display getDisplay() {
                return display;
            }
        };
    }

    public IntList hasItems(AbstractContainerMenu menu, MenuInfo<AbstractContainerMenu, Display> info, Display display, List<List<ItemStack>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        info.getRecipeFinderPopulator().populate(DefaultCategoryHandler.ofContext(menu, info, display), recipeFinder);
        IntArrayList intList = new IntArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            List<ItemStack> possibleStacks = inputs.get(i);
            boolean done = possibleStacks.isEmpty();
            for (ItemStack possibleStack : possibleStacks) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.m_41613_(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            intList.add(i);
        }
        return intList;
    }
}

