/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WeatherFavoriteEntry
extends FavoriteEntry {
    public static final ResourceLocation ID = new ResourceLocation("roughlyenoughitems", "weather");
    public static final String TRANSLATION_KEY = "favorite.section.weather";
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final String KEY = "weather";
    @Nullable
    private final Weather weather;

    public WeatherFavoriteEntry(@Nullable Weather weather) {
        this.weather = weather;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.weather == null) {
            List renderers = IntStream.range(0, 3).mapToObj(WeatherFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(showcase, renderers, () -> WeatherFavoriteEntry.getCurrentWeather().getId()){

                @Override
                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    return Tooltip.create(mouse, new Component[]{new TranslatableComponent("text.rei.weather_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return WeatherFavoriteEntry.getRenderer(this.weather.getId());
    }

    private static Weather getCurrentWeather() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world.m_46470_()) {
            return Weather.THUNDER;
        }
        if (world.m_6106_().m_6533_()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private static Renderer getRenderer(int id) {
        final Weather weather = Weather.byId(id);
        return new AbstractRenderer(){

            @Override
            public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    matrices.m_85836_();
                    matrices.m_85837_((double)bounds.getCenterX(), (double)bounds.getCenterY(), 0.0);
                    matrices.m_85841_((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f, 1.0f);
                    this.renderWeatherIcon(matrices, weather, 0, 0, color);
                    matrices.m_85849_();
                }
            }

            private void renderWeatherIcon(PoseStack matrices, Weather type, int centerX, int centerY, int color) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)CHEST_GUI_TEXTURE);
                2.m_93133_((PoseStack)matrices, (int)(centerX - 7), (int)(centerY - 7), (float)(type.getId() * 14), (float)14.0f, (int)14, (int)14, (int)256, (int)256);
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point mouse) {
                return Tooltip.create(mouse, new Component[]{new TranslatableComponent("text.rei.weather_button.tooltip.entry", new Object[]{new TranslatableComponent(weather.getTranslateKey())})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.getClass(), false, weather});
            }
        };
    }

    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            if (this.weather != null) {
                Minecraft.m_91087_().f_91074_.m_108739_(ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", this.weather.name().toLowerCase(Locale.ROOT)));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.weather == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.map(Weather.values(), WeatherMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.weather == null ? -1L : (long)this.weather.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        FavoriteEntry favoriteEntry = other;
        if (!(favoriteEntry instanceof WeatherFavoriteEntry)) {
            return false;
        }
        WeatherFavoriteEntry that = (WeatherFavoriteEntry)favoriteEntry;
        return Objects.equals((Object)this.weather, (Object)that.weather);
    }

    @ApiStatus.Internal
    public static enum Weather {
        CLEAR(0, "text.rei.weather.clear"),
        RAIN(1, "text.rei.weather.rain"),
        THUNDER(2, "text.rei.weather.thunder");

        private final int id;
        private final String translateKey;

        private Weather(int id, String translateKey) {
            this.id = id;
            this.translateKey = translateKey;
        }

        public static Weather byId(int id) {
            return Weather.byId(id, CLEAR);
        }

        public static Weather byId(int id, Weather defaultWeather) {
            for (Weather weather : Weather.values()) {
                if (weather.id != id) continue;
                return weather;
            }
            return defaultWeather;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslateKey() {
            return this.translateKey;
        }
    }

    public static class WeatherMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final Weather weather;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public WeatherMenuEntry(Weather weather) {
            this.text = I18n.m_118938_((String)weather.getTranslateKey(), (Object[])new Object[0]);
            this.weather = weather;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.m_92895_(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            if (this.selected) {
                WeatherMenuEntry.m_93172_((PoseStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
            }
            if (this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(new Component[]{new TranslatableComponent("text.rei.weather_button.tooltip.entry", new Object[]{this.text})}));
            }
            this.font.m_92883_(matrices, this.text, (float)(this.x + 2), (float)(this.y + 2), this.selected ? 0xFFFFFF : 0x888888);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12)) {
                Minecraft.m_91087_().f_91074_.m_108739_(ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", this.weather.name().toLowerCase(Locale.ROOT)));
                this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                this.closeMenu();
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    public static enum Type implements FavoriteEntryType<WeatherFavoriteEntry>
    {
        INSTANCE;


        @Override
        public DataResult<WeatherFavoriteEntry> readResult(CompoundTag object) {
            String stringValue = object.m_128461_(WeatherFavoriteEntry.KEY);
            Weather weather = stringValue.equals("NOT_SET") ? null : Weather.valueOf(stringValue);
            return DataResult.success((Object)new WeatherFavoriteEntry(weather), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<WeatherFavoriteEntry> fromArgsResult(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create WeatherFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Weather)) {
                return DataResult.error((String)"Creation of WeatherFavoriteEntry from args expected Weather as the first argument!");
            }
            Weather weather = (Weather)((Object)object);
            return DataResult.success((Object)new WeatherFavoriteEntry(weather), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(WeatherFavoriteEntry entry, CompoundTag tag) {
            tag.m_128359_(WeatherFavoriteEntry.KEY, entry.weather == null ? "NOT_SET" : entry.weather.name());
            return tag;
        }
    }
}

