/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler;
import me.shedaniel.rei.plugin.client.runtime.PluginStageExecutionWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchBarHighlightWatcher;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class DefaultClientRuntimePlugin
implements REIClientPlugin {
    public DefaultClientRuntimePlugin() {
        PluginStageExecutionWatcher watcher = new PluginStageExecutionWatcher();
        for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
            instance.registerReloadable(watcher.reloadable(instance));
        }
        REIRuntimeImpl.getInstance().addHintProvider(watcher);
        REIRuntimeImpl.getInstance().addHintProvider(new SearchBarHighlightWatcher());
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        if (((Boolean)ClientHelperImpl.getInstance().isAprilFools.m_13971_()).booleanValue()) {
            registry.addEntry(ClientEntryStacks.of(new AbstractRenderer(){
                private ResourceLocation id = new ResourceLocation("roughlyenoughitems", "textures/gui/kirb.png");

                @Override
                public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)this.id);
                    1.m_93112_((Matrix4f)matrices.m_85850_().m_85861_(), (int)bounds.x, (int)bounds.getMaxX(), (int)bounds.y, (int)bounds.getMaxY(), (int)this.m_93252_(), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }

                @Override
                @Nullable
                public Tooltip getTooltip(Point point) {
                    return Tooltip.create(new Component[]{new TextComponent("Kirby"), ClientHelper.getInstance().getFormattedModFromModId("Dream Land")});
                }
            }));
        }
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones zones = registry.exclusionZones();
        zones.register(DefaultDisplayViewingScreen.class, screen -> {
            Panel widget = screen.getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        zones.register(Screen.class, screen -> {
            FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
            if (widget != null && widget.favoritePanelButton.isVisible()) {
                return Collections.singletonList(widget.favoritePanelButton.bounds);
            }
            return Collections.emptyList();
        });
        registry.registerDecider(new DisplayBoundsProvider<AbstractDisplayViewingScreen>(){

            @Override
            public Rectangle getScreenBounds(AbstractDisplayViewingScreen screen) {
                return screen.getBounds();
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return AbstractDisplayViewingScreen.class.isAssignableFrom(screen);
            }

            @Override
            public InteractionResult shouldScreenBeOverlaid(Class<?> screen) {
                return InteractionResult.SUCCESS;
            }
        });
        registry.registerDraggableStackProvider(DraggableStackProviderWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().m_6702_(), DraggableStackProviderWidget.class::isInstance);
        }));
        registry.registerDraggableStackVisitor(DraggableStackVisitorWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().m_6702_(), DraggableStackVisitorWidget.class::isInstance);
        }));
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(EntryStackFavoriteType.INSTANCE.id, EntryStackFavoriteType.INSTANCE);
    }

    @Override
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new DefaultCategoryHandler());
    }

    private static enum EntryStackFavoriteType implements FavoriteEntryType<EntryStackFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.ENTRY_STACK);

        private final String key = "data";
        private ResourceLocation id;

        private EntryStackFavoriteType(ResourceLocation id) {
            this.id = id;
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> readResult(CompoundTag object) {
            EntryStack<?> stack;
            try {
                stack = EntryStack.read(object.m_128469_("data"));
            }
            catch (Throwable throwable) {
                return DataResult.error((String)throwable.getMessage());
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> fromArgsResult(Object ... args) {
            if (args.length == 0) {
                return DataResult.error((String)"Cannot create EntryStackFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof EntryStack)) {
                return DataResult.error((String)"Creation of EntryStackFavoriteEntry from args expected EntryStack as the first argument!");
            }
            EntryStack stack = (EntryStack)object;
            if (!stack.supportSaving()) {
                return DataResult.error((String)"Creation of EntryStackFavoriteEntry from an unserializable stack!");
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(EntryStackFavoriteEntry entry, CompoundTag tag) {
            tag.m_128365_("data", (Tag)entry.stack.save());
            return tag;
        }
    }

    private static class EntryStackFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final EntryStack<?> stack;
        private final long hash;

        public EntryStackFavoriteEntry(EntryStack<?> stack) {
            this.stack = stack.normalize();
            this.hash = EntryStacks.hashExact(this.stack);
        }

        @Override
        public boolean isInvalid() {
            return this.stack.isEmpty();
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            return this.stack;
        }

        @Override
        public boolean doAction(int button) {
            if (!ClientHelper.getInstance().isCheating()) {
                return false;
            }
            EntryStack<Object> entry = this.stack.copy();
            if (!entry.isEmpty()) {
                Item bucketItem;
                if (entry.getValueType() == FluidStack.class && (bucketItem = ((FluidStack)entry.getValue()).getFluid().m_6859_()) != null) {
                    entry = EntryStacks.of((ItemLike)bucketItem);
                }
                if (entry.getType() == VanillaEntryTypes.ITEM) {
                    ((ItemStack)entry.castValue()).m_41764_(button != 1 && !Screen.m_96638_() ? 1 : ((ItemStack)entry.castValue()).m_41741_());
                }
                return ClientHelper.getInstance().tryCheatingEntry(entry);
            }
            return false;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new EntryStackFavoriteEntry(this.stack.normalize());
        }

        @Override
        public ResourceLocation getType() {
            return EntryStackFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            FavoriteEntry favoriteEntry = other;
            if (!(favoriteEntry instanceof EntryStackFavoriteEntry)) {
                return false;
            }
            EntryStackFavoriteEntry that = (EntryStackFavoriteEntry)favoriteEntry;
            return EntryStacks.equalsExact(this.stack, that.stack);
        }
    }
}

