/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public abstract class DefaultCraftingDisplay<C extends Recipe<?>>
extends BasicDisplay
implements SimpleGridMenuDisplay {
    protected Optional<C> recipe;

    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<C> recipe) {
        super(inputs, outputs, Optional.empty());
        this.recipe = recipe;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public Optional<C> getOptionalRecipe() {
        return this.recipe;
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        return this.getOptionalRecipe().map(Recipe::m_6423_);
    }

    public <T extends AbstractContainerMenu> List<List<ItemStack>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultCraftingDisplay<?>> menuInfo, T container) {
        return CollectionUtils.map(this.getOrganisedInputEntries(menuInfo.getCraftingWidth(container), menuInfo.getCraftingHeight(container)), ingredient -> CollectionUtils.filterAndMap(ingredient, stack -> stack.getType() == VanillaEntryTypes.ITEM, EntryStack::castValue));
    }

    public <T extends AbstractContainerMenu> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, menuWidth), this.getInputEntries().get(i));
        }
        return list;
    }

    public static int getSlotWithSize(DefaultCraftingDisplay<?> display, int index, int craftingGridWidth) {
        return DefaultCraftingDisplay.getSlotWithSize(display.getWidth(), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    public static BasicDisplay.Serializer<DefaultCraftingDisplay<?>> serializer() {
        return BasicDisplay.Serializer.ofSimple(DefaultCustomDisplay::simple).inputProvider(display -> display.getOrganisedInputEntries(3, 3));
    }
}

