/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public class DefaultCustomDisplay
extends DefaultCraftingDisplay<Recipe<?>> {
    private int width;
    private int height;

    public DefaultCustomDisplay(@Nullable Recipe<?> possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
        super(input, output, Optional.ofNullable(possibleRecipe));
        BitSet row = new BitSet(3);
        BitSet column = new BitSet(3);
        for (int i = 0; i < 9; ++i) {
            EntryIngredient stacks;
            if (i >= input.size() || !(stacks = input.get(i)).stream().anyMatch(stack -> !stack.isEmpty())) continue;
            row.set((i - i % 3) / 3);
            column.set(i % 3);
        }
        this.width = column.cardinality();
        this.height = row.cardinality();
    }

    public static DefaultCustomDisplay simple(List<EntryIngredient> input, List<EntryIngredient> output, Optional<ResourceLocation> location) {
        Recipe optionalRecipe = location.flatMap(resourceLocation -> RecipeManagerContext.getInstance().getRecipeManager().m_44043_(resourceLocation)).orElse(null);
        return new DefaultCustomDisplay(optionalRecipe, input, output);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

