/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.tactical_fishing;

import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tactical_fishing")
public class TacticalFishing {
    public static final Logger LOG = LogManager.getLogger();
    private static final ResourceLocation ADVANCEMENT = new ResourceLocation("tactical_fishing", "husbandry/advanced_tactics");

    public TacticalFishing() {
        MinecraftForge.EVENT_BUS.addListener(this::onItemFished);
    }

    private void grantAdvancement(ServerPlayer ent, ResourceLocation advancement_id) {
        Advancement advancement = ent.m_20194_().m_129889_().m_136041_(advancement_id);
        if (advancement != null && !ent.m_8960_().m_135996_(advancement).m_8193_()) {
            for (String str : ent.m_8960_().m_135996_(advancement).m_8219_()) {
                ent.m_8960_().m_135988_(advancement, str);
            }
        } else if (!ent.m_8960_().m_135996_(advancement).m_8193_()) {
            LOG.warn("Couldn't award the '" + advancement_id.toString() + "' advancement");
        }
    }

    public void onItemFished(ItemFishedEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            InteractionHand bucket_carrier;
            Object object = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(Items.f_42447_) ? InteractionHand.MAIN_HAND : (bucket_carrier = player.m_21120_(InteractionHand.OFF_HAND).m_41720_().equals(Items.f_42447_) ? InteractionHand.OFF_HAND : null);
            if (bucket_carrier != null) {
                for (ItemStack drop : event.getDrops()) {
                    Item possible_bucket;
                    String key = drop.m_41720_().getRegistryName().m_135815_();
                    if (key.contains("raw_")) {
                        key = key.substring(4);
                    }
                    if ((possible_bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(drop.m_41720_().getRegistryName().m_135827_(), key + "_bucket"))) == null || possible_bucket.equals(Items.f_41852_)) continue;
                    player.m_21008_(bucket_carrier, possible_bucket.m_7968_());
                    if (player instanceof ServerPlayer) {
                        this.grantAdvancement((ServerPlayer)player, ADVANCEMENT);
                    }
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }
}

