/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.init;

import com.girafi.waddles.entity.AdeliePenguinEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="waddles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PenguinRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"waddles");
    private static final List<Item> SPAWN_EGGS = Lists.newArrayList();
    public static final RegistryObject<EntityType<AdeliePenguinEntity>> ADELIE_PENGUIN = PenguinRegistry.createEntity("adelie_penguin", AdeliePenguinEntity::new, 0.4f, 0.95f, 0, 0xFFFFFF);

    private static <T extends Animal> RegistryObject<EntityType<T>> createEntity(String name, EntityType.EntityFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("waddles", name);
        EntityType entity = EntityType.Builder.m_20704_(factory, (MobCategory)MobCategory.CREATURE).m_20699_(width, height).setTrackingRange(64).setUpdateInterval(1).m_20712_(location.toString());
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
        spawnEgg.setRegistryName(new ResourceLocation("waddles", name + "_spawn_egg"));
        SPAWN_EGGS.add((Item)spawnEgg);
        return ENTITY_DEFERRED.register(name, () -> entity);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ADELIE_PENGUIN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdeliePenguinEntity::canPenguinSpawn);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ADELIE_PENGUIN.get(), AdeliePenguinEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        for (Item spawnEgg : SPAWN_EGGS) {
            Preconditions.checkNotNull((Object)spawnEgg.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }
}

