/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.entity.forge;

import dev.architectury.platform.forge.EventBuses;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityRendererRegistryImpl {
    private static final Map<Supplier<EntityType<?>>, EntityRendererProvider<?>> RENDERERS = new ConcurrentHashMap();

    public static <T extends Entity> void register(Supplier<EntityType<? extends T>> type, EntityRendererProvider<T> factory) {
        RENDERERS.put(type, factory);
    }

    @SubscribeEvent
    public static void event(EntityRenderersEvent.RegisterRenderers event) {
        for (Map.Entry<Supplier<EntityType<?>>, EntityRendererProvider<?>> entry : RENDERERS.entrySet()) {
            event.registerEntityRenderer(entry.getKey().get(), entry.getValue());
        }
    }

    static {
        EventBuses.onRegistered("architectury", bus -> bus.register(EntityRendererRegistryImpl.class));
    }
}

